/*
 * @(#)ResourceUtilsTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.util;

import info.dragonlady.sso.util.ResourceUtils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import junit.framework.TestCase;

/**
 * ResourceUtilsNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/11 14:10:23 $
 */
public class ResourceUtilsTest extends TestCase {

	private String testResource = "test/info/dragonlady/sso/test_resource.xml";

	private String testString = "testString";

	/**
	 * Constructor for ResourceUtilsTest.
	 * @param arg0
	 */
	public ResourceUtilsTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.getString(String, String)'
	 */
	public final void testGetString() {
		try {
			String expected = "test_string";
			String expression = "test/test-string";
			String result = ResourceUtils.getString(testResource, expression);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.toBase64String(byte[])'
	 */
	public final void testToBase64String() {
		try {
			String expected = new String(Base64.encodeBase64(testString.getBytes()));
			String result = ResourceUtils.toBase64String(testString.getBytes());
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.toHexString(byte[])'
	 */
	public final void testToHexString() {
		try {
			String expected = new String(Hex.encodeHex(testString.getBytes()));
			String result = ResourceUtils.toHexString(testString.getBytes());
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.getNodeSet(String, String)'
	 */
	public final void testGetNodeSet() {
		try {
			Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			Element parentElm = doc.createElement("test-node-list-parent");
			for(int i = 1; i < 4; i++) {
				Element elm = doc.createElement("test-node-list");
				elm.appendChild(doc.createTextNode("test_node_list" + i));
				parentElm.appendChild(elm);
			}
			doc.appendChild(parentElm);

			NodeList expected = parentElm.getChildNodes();
			String expression = "test/test-node-list-parent/test-node-list";
			NodeList result = ResourceUtils.getNodeSet(testResource, expression);
			assertTrue(expected.getLength() == result.getLength());
			for(int i = 0; i < result.getLength(); i++) {
				assertTrue(ResourceUtils.getTextContent(expected.item(i)).equals(ResourceUtils.getTextContent(result.item(i))));
			}
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.evaluate(String, String, QName)'
	 */
	public final void testEvaluate() {
		try {
			Object expected = null;
			String expression = null;
			Object result = null;

			// BOOLEAN
			expected = Boolean.TRUE;
			expression = "test/test-boolean";
			result = ResourceUtils.evaluate(testResource, expression, XPathConstants.BOOLEAN);
			assertTrue(result instanceof Boolean);
			assertTrue(result.equals(expected));

			// NODE
			expected = "test_node";
			expression = "test/test-node";
			result = ResourceUtils.evaluate(testResource, expression, XPathConstants.NODE);
			assertTrue(result instanceof Node);
			assertTrue(ResourceUtils.getTextContent((Node)result).equals(expected));

			// NODESET
			Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			Element parentElm = doc.createElement("test-node-list-parent");
			for(int i = 1; i < 4; i++) {
				Element elm = doc.createElement("test-node-list");
				elm.appendChild(doc.createTextNode("test_node_list" + i));
				parentElm.appendChild(elm);
			}
			doc.appendChild(parentElm);
			expected = parentElm.getChildNodes();
			expression = "test/test-node-list-parent/test-node-list";
			result = ResourceUtils.evaluate(testResource, expression, XPathConstants.NODESET);
			assertTrue(result instanceof NodeList);
			assertTrue(((NodeList)expected).getLength() == ((NodeList)result).getLength());
			for(int i = 0; i < ((NodeList)result).getLength(); i++) {
				assertTrue(ResourceUtils.getTextContent(((NodeList)expected).item(i)).equals(ResourceUtils.getTextContent(((NodeList)result).item(i))));
			}

			// NUMBER
			expected = new Integer(123);
			expression = "test/test-number";
			result = ResourceUtils.evaluate(testResource, expression, XPathConstants.NUMBER);
			assertTrue(result instanceof Number);
			assertTrue(((Number)expected).doubleValue() == ((Number)result).doubleValue());

			// STRING
			expected = "test_string";
			expression = "test/test-string";
			result = ResourceUtils.evaluate(testResource, expression, XPathConstants.STRING);
			assertTrue(result instanceof String);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceUtils.getTextContent(Node)'
	 */
	public final void testGetTextContent() {
		try {
			Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			Element elm = doc.createElement("test-content");
			elm.appendChild(doc.createTextNode("test_content"));
			doc.appendChild(elm);

			Node node = doc.getFirstChild();
			String expected = "test_content";
			String result = ResourceUtils.getTextContent(node);
			assertTrue(expected.equals(result));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
