/*
 * @(#)AssertionSessionListenerTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.listener;

import info.dragonlady.sso.listener.AssertionSessionListener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSessionEvent;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.ResourceParseException;

import org.apache.cactus.ServletTestCase;

/**
 * AssertionSessionListener NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/11 16:16:38 $
 */
public class AssertionSessionListenerTest extends ServletTestCase {

	private String userId = "testuser";

	/**
	 * @param arg0
	 */
	public AssertionSessionListenerTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.listener.AssertionSessionListener#AssertionSessionListener()} ̂߂̃eXgE\bhB
	 */
	public final void testAssertionSessionListener() {
		try {
			new AssertionSessionListener();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.listener.AssertionSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)} ̂߂̃eXgE\bhB
	 */
	public final void testSessionCreated() {
		try {
			HttpSessionEvent event = new HttpSessionEvent(session);
			AssertionSessionListener listener = new AssertionSessionListener();
			listener.sessionCreated(event);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.listener.AssertionSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)} ̂߂̃eXgE\bhB
	 */
	public final void testSessionDestroyed() {
		try {
			// AT[V쐬Ăׂ̏
			AssertionGenerator.generateAssertion(session.getId(), userId, getAttributes());

			int size = AssertionManager.getInstance().getAssertionMap().size();

			HttpSessionEvent event = new HttpSessionEvent(session);
			AssertionSessionListener listener = new AssertionSessionListener();
			listener.sessionDestroyed(event);

			assertTrue(AssertionManager.getInstance().getAssertionMap().size() < size);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private final Map getAttributes() throws ResourceParseException {
		Map attributes = new HashMap();
		List keyList = SSOConfig.getSAMLAttributeList();
		for(int i = 0; i < keyList.size(); i++) {
			String key = keyList.get(i).toString();
			attributes.put(key, "val_" + key);
		}
		return attributes;
	}

}
