/*
 * @(#)ResponderServletTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.servlet;

import info.dragonlady.sso.servlet.ResponderServlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.ReceiverResource;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.SiteTransfer;
import info.dragonlady.sso.util.ResourceParseException;

import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * ResponderServlet NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 18:40:00 $
 */
public class ResponderServletTest extends ServletTestCase {


	private String userId = "testuser";

	private String target = "http://172.16.3.74:8080/sso_sample/target.html";

	/**
	 * @param arg0
	 */
	public ResponderServletTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.servlet.ResponderServlet#ResponderServlet()} ̂߂̃eXgE\bhB
	 */
	public final void testResponderServlet() {
		try {
			new ResponderServlet();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * T[oɃAT[Vݒ肵Ăׂ̏
	 * SiteTransferT[ubgĂяo
	 */
	public final void beginSetAssertion(WebRequest theRequest) {
		// ^[QbgTCgw
		theRequest.addParameter(SSOConstants.NAME_TARGET, target, WebRequest.GET_METHOD);
	}

	/**
	 * T[oɃAT[Vݒ肵Ăׂ̏
	 * SiteTransferT[ubgĂяo
	 */
	public final void testSetAssertion() {
		try {
			SiteTransfer st = new SiteTransfer(request, response);
			st.forwardTo(session.getId(), userId, getAttributes());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private final Map getAttributes() throws ResourceParseException {
		Map attributes = new HashMap();
		List keyList = SSOConfig.getSAMLAttributeList();
		for(int i = 0; i < keyList.size(); i++) {
			String key = keyList.get(i).toString();
			attributes.put(key, "val_" + key);
		}
		return attributes;
	}

	/**
	 * T[oɃAT[Vݒ肵Ăׂ̏
	 * SiteTransferT[ubgĂяo
	 */
	public final void endSetAssertion(WebResponse theResponse) {
		try {
			// URLmF
			String expectedReceiver = ReceiverResource.getReceiver("172.16.3.74", "sso_sample");
			String receiver = theResponse.getConnection().getHeaderField("Location");
			String[] str = receiver.split("\\?");
			assertTrue(expectedReceiver.equals(str[0]));
			String[] query = str[1].split("&");
			// TARGET,SAMLart̂Qp[^
			assertTrue(query.length == 2);
			for(int i = 0; i < query.length; i++) {
				String[] s = query[i].split("=");
				if(s[0].equals(SSOConstants.NAME_SAMLART)) {
					// artifact񑶍ݐݒ
					ArtifactManager.getInstance().setArtifact(URLDecoder.decode(s[1], "MS932"));
				}
			}
			String sessionId = theResponse.getCookie("JSESSIONID").getValue();
			ArtifactManager.getInstance().setSessionId(sessionId);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private String createSoapMessage() {
		StringBuffer sb = new StringBuffer();
		sb.append("<SOAP-ENV:Envelope\n");
		sb.append("xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">\n");
		sb.append("<SOAP-ENV:Body>\n");
		sb.append("<samlp:Request\n");
		sb.append("xmlns=\"urn:oasis:names:tc:SAML:1.0:protocol\"\n");
		sb.append("xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"\n");
		sb.append("xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"\n");
		sb.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchem\"\n");
		sb.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
		sb.append("IssueInstant=\"2005-11-24T09:59:41.546Z\"\n");
		sb.append("MajorVersion=\"1\"\n");
		sb.append("MinorVersion=\"1\"\n");
		sb.append("RequestID=\"_503927df0a1dfd7a34855aead48d932183f1a12b\">\n");
		sb.append("<samlp:AssertionArtifact>\n");
		sb.append(ArtifactManager.getInstance().getArtifact()+"\n");
//		sb.append("AAHyzDGlMaGfj50IThXR1yE00SD6tbnFfZuaqGNAHk/isHzPHXqJEirV\n");
		sb.append("</samlp:AssertionArtifact>\n");
		sb.append("</samlp:Request>\n");
		sb.append("</SOAP-ENV:Body>\n");
		sb.append("</SOAP-ENV:Envelope>\n");
		return sb.toString();
	}

	public final void beginServiceHttpServletRequestHttpServletResponse(WebRequest theRequest) {
		try {
			theRequest.setContentType("text/xml");
			theRequest.addParameter("SOAPAction", "http://www.oasis-open.org/committees/security", WebRequest.POST_METHOD);
			theRequest.setUserData(new BufferedInputStream(
					new ByteArrayInputStream(createSoapMessage().getBytes())));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * 
	 * 
	 * {@link info.dragonlady.sso.servlet.ResponderServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)} ̂߂̃eXgE\bhB
	 */
	public final void testServiceHttpServletRequestHttpServletResponse() {
		try {
			ResponderServlet responder = new ResponderServlet();
			responder.service(request, response);
		} catch(Exception e) {
			assertTrue(e.toString(), true);
		}
	}

	public final void endServiceHttpServletRequestHttpServletResponse(WebResponse theResponse) {
		try {
			// SAMLXe[^XSUCCESSȂOK
			InputStream is = theResponse.getInputStream();
			byte[] b = new byte[is.available()];
			is.read(b);
			String content = new String(b, "UTF-8");
			content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n" + content;
			Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(content.getBytes()));
			assertTrue(checkSuccessStatus(dom));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private final boolean checkSuccessStatus(Node n) {
		NodeList nList = n.getChildNodes();
		for(int i = 0; i < nList.getLength(); i++) {
			Node node = nList.item(i);
			if(node.getNodeName().equals("StatusCode")) {
				NamedNodeMap nMap = node.getAttributes();
				Node attrNode = nMap.getNamedItem("Value");
				return attrNode.getNodeValue().equals("samlp:Success");
//				NodeList nl = attrNode.getChildNodes();
//				for(int j = 0; j < nl.getLength(); j++) {
//					Node item = nl.item(j);
//					if(item.getNodeType() == Node.TEXT_NODE) {
//						return item.getNodeValue().equals("samlp:Success");
//					}
//				}
			} else {
				boolean res = checkSuccessStatus(node);
				if(res) {
					return res;
				}
			}
		}
		return false;
	}

	public final void beginServiceHttpServletRequestHttpServletResponse2(WebRequest theRequest) {
		try {
			theRequest.setContentType("text/xml");
			// AT[Vo^ZbVIDw
			theRequest.addParameter("dummySessionId", ArtifactManager.getInstance().getSessionId(), WebRequest.GET_METHOD);
			theRequest.addParameter("SOAPAction", "http://www.oasis-open.org/committees/security", WebRequest.POST_METHOD);
			theRequest.setUserData(new BufferedInputStream(
					new ByteArrayInputStream(createSoapMessage().getBytes())));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * siΉAT[VȂj
	 * 
	 */
	public final void testServiceHttpServletRequestHttpServletResponse2() {
		try {
			// ΉAT[V폜Ă
			AssertionManager.getInstance().removeById(request.getParameter("dummySessionId"));

			ResponderServlet responder = new ResponderServlet();
			responder.service(request, response);
		} catch(Exception e) {
			assertTrue(e.toString(), true);
		}
	}

	public final void endServiceHttpServletRequestHttpServletResponse2(WebResponse theResponse) {
		try {
			InputStream is = theResponse.getInputStream();
			byte[] b = new byte[is.available()];
			is.read(b);
			String content = new String(b, "UTF-8");
			content = "<?xml version=\"1.0\" encoding=\"Shift_JIS\" ?>\n" + content;
			Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(content.getBytes()));
			assertTrue(checkFaultStatus(dom));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private final boolean checkFaultStatus(Node n) {
		NodeList nList = n.getChildNodes();
		for(int i = 0; i < nList.getLength(); i++) {
			Node node = nList.item(i);
			if(node.getNodeName().equals("faultcode")) {
				NodeList nl = node.getChildNodes();
				for(int j = 0; j < nl.getLength(); j++) {
					Node item = nl.item(j);
					if(item.getNodeType() == Node.TEXT_NODE) {
						return item.getNodeValue().equals("soap:Server");
					}
				}
			} else {
				boolean res = checkFaultStatus(node);
				if(res) {
					return res;
				}
			}
		}
		return false;
	}

	public final void beginServiceHttpServletRequestHttpServletResponse3(WebRequest theRequest) {
		try {
			theRequest.setContentType("text/xml");
			theRequest.addParameter("SOAPAction", "http://www.oasis-open.org/committees/security", WebRequest.GET_METHOD);
			// XMLf[^MȂ
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * GETvłSOAPoCfBOŖG[
	 * 
	 */
	public final void testServiceHttpServletRequestHttpServletResponse3() {
		try {
			ResponderServlet responder = new ResponderServlet();
			responder.service(request, response);
		} catch(Exception e) {
			assertTrue(e.toString(), true);
		}
	}

	public final void endServiceHttpServletRequestHttpServletResponse3(WebResponse theResponse) {
		try {
			assertTrue(theResponse.getStatusCode() == 403);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
