/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSignedObject;
import org.opensaml.SAMLStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAssertion
extends SAMLSignedObject
implements Cloneable {
    protected int minor;
    protected String assertionId;
    protected String issuer;
    protected Date issueInstant;
    protected Date notBefore;
    protected Date notOnOrAfter;
    protected ArrayList conditions;
    protected ArrayList advice;
    protected ArrayList statements;

    protected void insertSignature() throws SAMLException {
        this.root.appendChild(this.getSignatureElement());
    }

    public SAMLAssertion() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
    }

    public SAMLAssertion(String string, Date date, Date date2, Collection collection, Collection collection2, Collection collection3) throws SAMLException {
        this(SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date(), string, date, date2, collection, collection2, collection3);
    }

    public SAMLAssertion(String string, Date date, String string2, Date date2, Date date3, Collection collection, Collection collection2, Collection collection3) throws SAMLException {
        Iterator iterator;
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.assertionId = XML.assign(string);
        this.issueInstant = date;
        this.issuer = XML.assign(string2);
        this.notBefore = date2;
        this.notOnOrAfter = date3;
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.conditions.add(((SAMLCondition)iterator.next()).setParent(this));
            }
        }
        if (collection2 != null) {
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String && ((String)e).length() > 0) {
                    this.advice.add(e);
                    continue;
                }
                if (e instanceof SAMLAssertion) {
                    this.advice.add(((SAMLAssertion)e).setParent(this));
                    continue;
                }
                if (e instanceof Element && ((Element)e).getParentNode() == null && !((Element)e).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    this.advice.add(e);
                    continue;
                }
                throw new IllegalArgumentException("SAMLAssertion() can only process advice Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
            }
        }
        if (collection3 != null) {
            iterator = collection3.iterator();
            while (iterator.hasNext()) {
                this.statements.add(((SAMLStatement)iterator.next()).setParent(this));
            }
        }
    }

    public SAMLAssertion(Element element) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(element);
    }

    public SAMLAssertion(InputStream inputStream) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(SAMLAssertion.fromStream(inputStream));
    }

    public SAMLAssertion(InputStream inputStream, int n) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(SAMLAssertion.fromStream(inputStream, n));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() requires saml:Assertion at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLAssertion.fromDOM() detected incompatible assertion major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(element.getAttributeNS(null, "MinorVersion"));
        this.issuer = XML.assign(element.getAttributeNS(null, "Issuer"));
        this.assertionId = XML.assign(element.getAttributeNS(null, "AssertionID"));
        if (this.minor > 0) {
            element.setIdAttributeNode(element.getAttributeNodeNS(null, "AssertionID"), true);
        }
        try {
            SimpleDateFormat simpleDateFormat = null;
            String string = element.getAttributeNS(null, "IssueInstant");
            simpleDateFormat = string.indexOf(46) > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = simpleDateFormat.parse(string);
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null) {
                Element element3;
                if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions")) {
                    if (element2.hasAttributeNS(null, "NotBefore")) {
                        this.notBefore = simpleDateFormat.parse(element2.getAttributeNS(null, "NotBefore"));
                    }
                    if (element2.hasAttributeNS(null, "NotOnOrAfter")) {
                        this.notOnOrAfter = simpleDateFormat.parse(element2.getAttributeNS(null, "NotOnOrAfter"));
                    }
                    element3 = XML.getFirstChildElement(element2);
                    while (element3 != null) {
                        this.conditions.add(SAMLCondition.getInstance(element3).setParent(this));
                        element3 = XML.getNextSiblingElement(element3);
                    }
                } else if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
                    element3 = XML.getFirstChildElement(element2);
                    while (element3 != null) {
                        if (XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference") && element3.hasChildNodes()) {
                            this.advice.add(element3.getFirstChild().getNodeValue());
                        } else if (XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                            this.advice.add(new SAMLAssertion(element3).setParent(this));
                        } else {
                            this.advice.add(element3);
                        }
                        element3 = XML.getNextSiblingElement(element3);
                    }
                } else if (!XML.isElementNamed(element2, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                    this.statements.add(SAMLStatement.getInstance(element2).setParent(this));
                }
                element2 = XML.getNextSiblingElement(element2);
            }
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() detected an invalid datetime while parsing assertion", (Exception)parseException);
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int n) {
        this.minor = n;
        this.setDirty(true);
    }

    public String getId() {
        return this.assertionId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.assertionId = string;
        this.setDirty(true);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("issuer cannot be null");
        }
        this.issuer = string;
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = date;
        this.setDirty(true);
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date date) {
        this.notBefore = date;
        this.setDirty(true);
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date date) {
        this.notOnOrAfter = date;
        this.setDirty(true);
    }

    public Iterator getConditions() {
        return this.conditions.iterator();
    }

    public void setConditions(Collection collection) throws SAMLException {
        this.conditions.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.conditions.add(((SAMLCondition)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addCondition(SAMLCondition sAMLCondition) throws SAMLException {
        if (sAMLCondition == null) {
            throw new IllegalArgumentException("c cannot be null");
        }
        this.conditions.add(sAMLCondition.setParent(this));
        this.setDirty(true);
    }

    public void removeCondition(int n) throws IndexOutOfBoundsException {
        this.conditions.remove(n);
        this.setDirty(true);
    }

    public Iterator getAdvice() {
        return this.advice.iterator();
    }

    public void setAdvice(Collection collection) throws SAMLException {
        this.advice.clear();
        this.setDirty(true);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAdvice(iterator.next());
            }
        }
    }

    public void addAdvice(Object object) throws SAMLException {
        if (object != null && (object instanceof String || object instanceof SAMLAssertion || object instanceof Element && !((Element)object).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion"))) {
            if (object instanceof SAMLAssertion) {
                ((SAMLAssertion)object).setParent(this);
            }
        } else {
            throw new IllegalArgumentException("SAMLAssertion.addAdvice() can only process Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
        }
        this.advice.add(object);
        this.setDirty(true);
    }

    public void removeAdvice(int n) throws IndexOutOfBoundsException {
        this.advice.remove(n);
        this.setDirty(true);
    }

    public Iterator getStatements() {
        return this.statements.iterator();
    }

    public void setStatements(Collection collection) throws SAMLException {
        this.statements.clear();
        this.setDirty(true);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.statements.add(((SAMLStatement)iterator.next()).setParent(this));
            }
        }
    }

    public void addStatement(SAMLStatement sAMLStatement) throws SAMLException {
        if (sAMLStatement == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        this.statements.add(sAMLStatement.setParent(this));
        this.setDirty(true);
    }

    public void removeStatement(int n) throws IndexOutOfBoundsException {
        this.statements.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            Iterator iterator;
            Object object;
            if (this.assertionId == null) {
                this.assertionId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            element.setAttributeNS(null, "MajorVersion", "1");
            element.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            element.setAttributeNS(null, "AssertionID", this.assertionId);
            if (this.minor > 0) {
                element.setIdAttributeNS(null, "AssertionID", true);
            }
            element.setAttributeNS(null, "Issuer", this.issuer);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
            if (this.conditions.size() > 0 || this.notBefore != null || this.notOnOrAfter != null) {
                object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
                if (this.notBefore != null) {
                    object.setAttributeNS(null, "NotBefore", simpleDateFormat.format(this.notBefore));
                }
                if (this.notOnOrAfter != null) {
                    object.setAttributeNS(null, "NotOnOrAfter", simpleDateFormat.format(this.notOnOrAfter));
                }
                element.appendChild((Node)object);
                iterator = this.conditions.iterator();
                while (iterator.hasNext()) {
                    object.appendChild(((SAMLCondition)iterator.next()).toDOM(document, false));
                }
            }
            if (this.advice.size() > 0) {
                object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
                iterator = this.advice.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof String && !XML.isEmpty((String)e)) {
                        Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                        element2.appendChild(document.createTextNode((String)e));
                        object.appendChild(element2);
                        continue;
                    }
                    if (e instanceof SAMLAssertion) {
                        object.appendChild(((SAMLAssertion)e).toDOM(document, false));
                        continue;
                    }
                    if (!(e instanceof Element)) continue;
                    object.appendChild(document.adoptNode((Element)e));
                }
                element.appendChild((Node)object);
            }
            object = this.statements.iterator();
            while (object.hasNext()) {
                element.appendChild(((SAMLStatement)object.next()).toDOM(document, false));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.issuer) || this.statements.size() == 0) {
            throw new MalformedException("Assertion is invalid, must have Issuer, and at least one Statement");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAssertion sAMLAssertion = (SAMLAssertion)super.clone();
        try {
            sAMLAssertion.conditions = new ArrayList();
            Iterator iterator = this.conditions.iterator();
            while (iterator.hasNext()) {
                sAMLAssertion.conditions.add(((SAMLCondition)((SAMLCondition)iterator.next()).clone()).setParent(sAMLAssertion));
            }
            sAMLAssertion.advice = new ArrayList();
            iterator = this.advice.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    sAMLAssertion.advice.add(e);
                    continue;
                }
                if (e instanceof SAMLAssertion) {
                    sAMLAssertion.advice.add(((SAMLAssertion)((SAMLAssertion)iterator.next()).clone()).setParent(sAMLAssertion));
                    continue;
                }
                sAMLAssertion.advice.add(((Element)e).cloneNode(true));
            }
            sAMLAssertion.statements = new ArrayList();
            iterator = this.statements.iterator();
            while (iterator.hasNext()) {
                sAMLAssertion.statements.add(((SAMLStatement)((SAMLStatement)iterator.next()).clone()).setParent(sAMLAssertion));
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLAssertion;
    }
}

