/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SAMLSubjectQuery
extends SAMLQuery
implements Cloneable {
    protected SAMLSubject subject = null;

    public SAMLSubjectQuery() {
    }

    public SAMLSubjectQuery(SAMLSubject sAMLSubject) throws SAMLException {
        this.subject = (SAMLSubject)sAMLSubject.setParent(this);
    }

    public SAMLSubjectQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLSubjectQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLSubjectQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        this.subject = (SAMLSubject)new SAMLSubject(XML.getFirstChildElement(element)).setParent(this);
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SAMLSubject sAMLSubject) throws SAMLException {
        if (sAMLSubject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.subject = (SAMLSubject)sAMLSubject.setParent(this);
        this.setDirty(true);
    }

    public void checkValidity() throws SAMLException {
        if (this.subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SubjectQuery invalid, requires subject");
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        if (this.dirty) {
            ((Element)this.root).appendChild(this.subject.toDOM(document));
        }
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubjectQuery sAMLSubjectQuery = (SAMLSubjectQuery)super.clone();
        try {
            sAMLSubjectQuery.subject = (SAMLSubject)((SAMLSubject)this.subject.clone()).setParent(sAMLSubjectQuery);
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLSubjectQuery;
    }
}

