/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.AssertionService;
import info.dragonlady.cluster.AssertionServiceException;
import info.dragonlady.cluster.Friend;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opensaml.SAMLAssertion;

public class AssertionServiceWrapper {
    public static final void put(SAMLAssertion assertion) throws AssertionServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOConfig.getServiceName(args[0], args[1], "AssertionService");
                    AssertionService service = (AssertionService)Naming.lookup(name);
                    String handleStr = AssertionManager.getInstance().getHandleMap().get(assertion.getId());
                    service.put(handleStr, assertion.toString());
                    Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6113", args));
                }
                catch (ConnectException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6101", args), (Throwable)e);
                }
                catch (NotBoundException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6102", args), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6103", args), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6104");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new AssertionServiceException(message, e);
        }
    }

    public static final void remove(String id) throws AssertionServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOConfig.getServiceName(args[0], args[1], "AssertionService");
                    AssertionService service = (AssertionService)Naming.lookup(name);
                    service.remove(id);
                    Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6114", args));
                }
                catch (ConnectException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6105", args), (Throwable)e);
                }
                catch (NotBoundException e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6106", args), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6107", args), (Throwable)e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6108");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new AssertionServiceException(message, e);
        }
    }

    public static final void synchronize() throws AssertionServiceException {
        try {
            Friend[] friends = SSOConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                block7: {
                    Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                    try {
                        String name = SSOConfig.getServiceName(args[0], args[1], "AssertionService");
                        AssertionService service = (AssertionService)Naming.lookup(name);
                        Map<String, String> handleMap = service.getHandleMap();
                        Map<String, String> assertionMap = service.getAssertionMap();
                        if (handleMap == null || assertionMap == null) break block7;
                        AssertionManager.getInstance().setMap(assertionMap, handleMap);
                        Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6115", args));
                        break;
                    }
                    catch (ConnectException e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6109", args), (Throwable)e);
                    }
                    catch (NotBoundException e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6110", args), (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.getRootLogger().warn((Object)SSOMessageResource.getMessage("6111", args), (Throwable)e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6112");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new AssertionServiceException(message, e);
        }
    }
}

