/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.Requester;
import info.dragonlady.sso.ResponderResource;
import info.dragonlady.sso.SSOContext;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionParser;
import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLBrowserProfileFactory;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.SAMLArtifactType0001;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactReceiver {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String authId = null;
    private Map<String, List<String>> attributes = null;
    private long expirationTime = 0L;
    private String targetUrl = null;

    public ArtifactReceiver(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void receive() throws SSOException {
        SAMLBrowserProfile.BrowserProfileResponse bpr = null;
        String artifact = null;
        try {
            SAMLBrowserProfile profile = SAMLBrowserProfileFactory.getInstance();
            SAMLBrowserProfile.BrowserProfileRequest bpReq = profile.receive(this.request);
            this.targetUrl = bpReq.TARGET;
            artifact = bpReq.SAMLArt != null && bpReq.SAMLArt.length > 0 ? bpReq.SAMLArt[0] : null;
            bpr = profile.receive(null, bpReq, null, SSOContext.getInstance().getReplayCache(), (SAMLBrowserProfile.ArtifactMapper)new Requester(this.getResponder(artifact)), 1);
            if (bpr != null && bpr.response != null) {
                Iterator itr = bpr.response.getAssertions();
                while (itr.hasNext()) {
                    SAMLAssertion assertion = (SAMLAssertion)itr.next();
                    AssertionParser parser = new AssertionParser(assertion);
                    if (parser.containsAuthenticationStatement()) {
                        this.authId = parser.getName();
                        this.expirationTime = assertion.getNotOnOrAfter().getTime();
                    }
                    if (!parser.containsAttributeStatement()) continue;
                    this.attributes = parser.getAttribute();
                }
            }
        }
        catch (Exception e) {
            throw new SSOException(SSOMessageResource.getMessage("1201", new Object[]{this.targetUrl, artifact}), e);
        }
    }

    public String getAuthId() {
        return this.authId;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void redirectToTarget() throws IOException {
        this.response.sendRedirect(this.targetUrl);
    }

    private String getResponder(String artifactStr) throws ArtifactParseException, ArtifactParserException, ResourceParseException {
        String responder = null;
        Artifact artifact = SAMLArtifact.getTypeCode((String)artifactStr).getParser().parse(artifactStr);
        if (artifact instanceof SAMLArtifactType0001) {
            String srcId = ResourceUtils.toBase64String(((SAMLArtifactType0001)artifact).getSourceId());
            responder = ResponderResource.getResponder(srcId);
        }
        return responder;
    }
}

