/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.ConsumerResource;
import info.dragonlady.sso.ReceiverResource;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.ResourceParseException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSignedObject;
import org.opensaml.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteTransfer {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private final String defaultEncoding = "ISO-2022-JP";

    public SiteTransfer(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void forward(List<Artifact> artifacts, Map<String, String> params) throws SSOException {
        try {
            StringBuffer redirectURL = new StringBuffer();
            String target = this.request.getParameter("TARGET");
            String encodeStr = this.request.getCharacterEncoding();
            if (encodeStr == null || encodeStr.length() < 1) {
                encodeStr = "ISO-2022-JP";
            }
            URL targetUrl = new URL(target);
            redirectURL.append(ReceiverResource.getReceiver(targetUrl.getHost(), this.getContext(targetUrl)));
            redirectURL.append("?TARGET=" + URLEncoder.encode(target, encodeStr));
            int i = 0;
            while (i < artifacts.size()) {
                redirectURL.append("&SAMLart=" + URLEncoder.encode(artifacts.get(i).encode(), encodeStr));
                ++i;
            }
            if (params != null) {
                for (String key : params.keySet()) {
                    String value = params.get(key);
                    redirectURL.append("&" + key + "=" + value);
                }
            }
            this.response.sendRedirect(redirectURL.toString());
        }
        catch (Exception e) {
            throw new SSOException(SSOMessageResource.getMessage("1001"), e);
        }
    }

    public Map<String, Object> getPostData(List<SAMLAssertion> assertions, Map<String, String> params) throws SSOException {
        try {
            for (SAMLAssertion assertion : assertions) {
                if (assertion.isSigned()) continue;
                this.sign((SAMLSignedObject)assertion);
            }
            String target = this.request.getParameter("TARGET");
            URL targetUrl = new URL(target);
            String consumerUrl = ConsumerResource.getConsumer(targetUrl.getHost(), this.getContext(targetUrl));
            SAMLException samlException = new SAMLException(SAMLException.SUCCESS);
            SAMLResponse samlResponse = new SAMLResponse(null, consumerUrl, assertions, samlException);
            this.sign((SAMLSignedObject)samlResponse);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("SAMLResponse", samlResponse);
            data.put("TARGET", target);
            data.put("Consumer", consumerUrl);
            if (params != null) {
                data.put("PostParam", params);
            }
            return data;
        }
        catch (Exception e) {
            throw new SSOException(SSOMessageResource.getMessage("1002"), e);
        }
    }

    private String getContext(URL targetUrl) {
        String context = "";
        String[] s = targetUrl.getPath().split("/");
        int i = 0;
        while (i < s.length) {
            if (s[i].length() > 0) {
                context = s[i];
                break;
            }
            ++i;
        }
        return context;
    }

    private void sign(SAMLSignedObject object) throws ResourceParseException, CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, SAMLException {
        String certPath = SSOConfig.getCertPath();
        FileInputStream fis = new FileInputStream(certPath);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = null;
        while (bis.available() > 0) {
            cert = cf.generateCertificate(bis);
        }
        fis.close();
        bis.close();
        String storePath = SSOConfig.getKeyStorePath();
        fis = new FileInputStream(storePath);
        bis = new BufferedInputStream(fis);
        String password = SSOConfig.getKeyStorePassword();
        String alias = SSOConfig.getKeyStoreAlias();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        while (bis.available() > 0) {
            ks.load(bis, password.toCharArray());
        }
        Key key = ks.getKey(alias, password.toCharArray());
        fis.close();
        bis.close();
        object.sign("http://www.w3.org/2000/09/xmldsig#dsa-sha1", key, (Collection)Arrays.asList(cert));
    }
}

