/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.authority;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.authority.SAMLAuthority;
import info.dragonlady.sso.util.ResourceParseException;
import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;

public class SAMLAuthorityProvider {
    public static final SAMLAuthority getAuthority(SAMLRequest request) throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        SAMLAuthority authority = null;
        SAMLQuery query = request.getQuery();
        if (query instanceof SAMLAuthenticationQuery) {
            authority = SAMLAuthorityProvider.getAuthenticationAuthority();
        } else if (query instanceof SAMLAttributeQuery) {
            authority = SAMLAuthorityProvider.getAttributeAuthority();
        } else if (query instanceof SAMLAuthorizationDecisionQuery) {
            authority = SAMLAuthorityProvider.getPolicyDecisionPoint();
        }
        return authority;
    }

    public static final SAMLAuthority getAuthenticationAuthority() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return SAMLAuthorityProvider.getAuthority(SSOConfig.getAuthenticationAuthorityClass());
    }

    public static final SAMLAuthority getAttributeAuthority() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return SAMLAuthorityProvider.getAuthority(SSOConfig.getAttributeAuthorityClass());
    }

    public static final SAMLAuthority getPolicyDecisionPoint() throws ResourceParseException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return SAMLAuthorityProvider.getAuthority(SSOConfig.getPolicyDecisionPointClass());
    }

    public static final SAMLAuthority getAuthority(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (SAMLAuthority)Class.forName(className).newInstance();
    }
}

