/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.ArtifactReceiver;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.servlet.SSOBaseServlet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ArtifactReceiverServlet
extends SSOBaseServlet {
    private static final long serialVersionUID = 4961766901123080450L;

    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ArtifactReceiver receiver = new ArtifactReceiver(request, response);
            receiver.receive();
            String authId = receiver.getAuthId();
            Map<String, List<String>> attributes = receiver.getAttributes();
            HttpSession session = request.getSession();
            session.setAttribute(SSOConfig.getLoginKey(), (Object)authId);
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    session.setAttribute(key, attributes.get(key));
                }
            }
            LoginManager.getInstance().add(authId, session.getId());
            if (!SSOConfig.isClusterStandalone()) {
                UserServiceWrapper.add(authId, session.getId());
            }
            receiver.redirectToTarget();
        }
        catch (SSOException e) {
            this.processException(SSOMessageResource.getMessage("5201"), e, response, 403);
        }
        catch (Exception e) {
            this.processException(SSOMessageResource.getMessage("5202"), e, response, 404);
        }
    }
}

