/*
 * @(#)ResponderResource.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;

/**
 * \[XIDƃX|_URL̃}bsO\[XANZXNX
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/11 14:08:42 $
 */
public class ResponderResource {

	/**
	 * \[XpX
	 */
	private static final String resourcePath = "resources/responder.xml";

	/**
	 * \[XID烌X|_URL擾
	 * 
	 * @param srcId \[XID
	 * @return String X|_URL
	 * @throws ResourceParseException
	 */
	public static final String getResponder(String srcId) throws ResourceParseException {
		String expression = "responder-list/responder[@src-id=\"" + srcId + "\"]/@url";
		String url = ResourceUtils.getString(ResponderResource.resourcePath, expression);
		String sessionId = SSOContext.getInstance().getCurrentRequest().getParameter(SSOConstants.NAME_SESSIONID);
		if(sessionId != null && sessionId.length() > 0) {
			url += ";" + SSOConstants.NAME_SESSIONID + "=" + sessionId;
		}
		return url;
	}

}
