/*
 * @(#)AttributeAuthorityTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import info.dragonlady.sso.Requester;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;

import junit.framework.TestCase;

/**
 * AttributeAuthorityNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/06 20:53:18 $
 */
public class AttributeAuthorityTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AttributeAuthorityTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.authority.AttributeAuthority#query(org.opensaml.SAMLRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery() {
		try {
			// ̏ꍇ
			String authId = "authId";
			SAMLAssertion authAssertion = AssertionGenerator.generateAuthenticationAssertion(authId, "confirmationMethod", "authMethod");
			List<String> attributeNames = new ArrayList<String>();
			attributeNames.add("attribute_name");

			TestAttributeAuthority authority = new TestAttributeAuthority();
			authority.setResult(true);
			SAMLRequest request = Requester.createAttributeRequest(authAssertion, attributeNames);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.SUCCESS);
			SAMLAssertion assertion = (SAMLAssertion)response.getAssertions().next();
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getName().equals(authId));
			assertTrue(parser.getAttribute().equals(((TestAttributeAuthority)authority).getAttributes(authId, attributeNames)));
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.AttributeAuthority#getAttributes(java.lang.String, java.util.List)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery2() {
		try {
			// s̏ꍇ
			String authId = "authId";
			SAMLAssertion authAssertion = AssertionGenerator.generateAuthenticationAssertion(authId, "confirmationMethod", "authMethod");
			List<String> attributeNames = new ArrayList<String>();
			attributeNames.add("attribute_name");

			TestAttributeAuthority authority = new TestAttributeAuthority();
			authority.setResult(false);
			SAMLRequest request = Requester.createAttributeRequest(authAssertion, attributeNames);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.RESPONDER);
			assertTrue(!response.getAssertions().hasNext());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
