/*
 * @(#)SAMLAuthorityProviderTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLRequest;

import info.dragonlady.sso.Requester;
import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.authority.AttributeAuthority;
import info.dragonlady.sso.authority.AuthenticationAuthority;
import info.dragonlady.sso.authority.PolicyDecisionPoint;
import info.dragonlady.sso.authority.SAMLAuthority;
import info.dragonlady.sso.authority.SAMLAuthorityProvider;
import info.dragonlady.sso.util.AssertionGenerator;
import junit.framework.TestCase;

/**
 * SAMLAuthorityProviderNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 19:56:13 $
 */
public class SAMLAuthorityProviderTest extends TestCase {

	/**
	 * @param arg0
	 */
	public SAMLAuthorityProviderTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.authority.SAMLAuthorityProvider#getAuthority(org.opensaml.SAMLRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testGetAuthoritySAMLRequest() {
		try {
			SAMLRequest request = Requester.createAuthenticationRequest(null, null, "authId", "confirmationMethod", "confirmationData", "authMethod");
			assertTrue(SAMLAuthorityProvider.getAuthority(request) instanceof AuthenticationAuthority);

			SAMLAssertion authAssertion = AssertionGenerator.generateAuthenticationAssertion("authId", "confirmationMethod", "authMethod");
			List<String> attributeNames = new ArrayList<String>();
			attributeNames.add("attribute_name");
			request = Requester.createAttributeRequest(authAssertion, attributeNames);
			assertTrue(SAMLAuthorityProvider.getAuthority(request) instanceof AttributeAuthority);

			List<String> values = new ArrayList<String>();
			values.add("attribute_value");
			Map<String, List<String>> attributes = new HashMap<String, List<String>>();
			attributes.put("attribute_name", values);
			SAMLAssertion attrAssertion = AssertionGenerator.generateAttributeAssertion("authId", attributes);
			request = Requester.createAuthorizationDecisionRequest(authAssertion, attrAssertion, new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET), "resource");
			assertTrue(SAMLAuthorityProvider.getAuthority(request) instanceof PolicyDecisionPoint);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.SAMLAuthorityProvider#getAuthenticationAuthority()} ̂߂̃eXgE\bhB
	 */
	public final void testGetAuthenticationAuthority() {
		try {
			assertTrue(SAMLAuthorityProvider.getAuthenticationAuthority() instanceof AuthenticationAuthority);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.SAMLAuthorityProvider#getAttributeAuthority()} ̂߂̃eXgE\bhB
	 */
	public final void testGetAttributeAuthority() {
		try {
			assertTrue(SAMLAuthorityProvider.getAttributeAuthority() instanceof AttributeAuthority);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.SAMLAuthorityProvider#getPolicyDecisionPoint()} ̂߂̃eXgE\bhB
	 */
	public final void testGetPolicyDecisionPoint() {
		try {
			assertTrue(SAMLAuthorityProvider.getPolicyDecisionPoint() instanceof PolicyDecisionPoint);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.SAMLAuthorityProvider#getAuthority(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testGetAuthorityString() {
		try {
			String className = "test.info.dragonlady.sso.authority.TestAuthenticationAuthority";
			assertTrue(SAMLAuthorityProvider.getAuthority(className) instanceof SAMLAuthority);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
