/*
 * @(#)SessionAuthenticatorTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.helper;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.helper.Authenticator;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SessionAuthenticator;

import org.apache.cactus.ServletTestCase;

/**
 * SessionAuthenticator NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 14:26:16 $
 */
public class SessionAuthenticatorTest extends ServletTestCase {

	/**
	 * @param arg0
	 */
	public SessionAuthenticatorTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.helper.SessionAuthenticator#SessionAuthenticator()} ̂߂̃eXgE\bhB
	 */
	public final void testSessionAuthenticator() {
		try {
			new SessionAuthenticator();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SessionAuthenticator#authenticate(javax.servlet.http.HttpServletRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthenticate() {
		try {
			Authenticator authenticator = new SessionAuthenticator();

			// F؎s̏ꍇ
			boolean result = authenticator.authenticate(request);
			assertTrue(!result);

			// Fؐ̏ꍇ
			// ZbVɑݒ
			LoginManager.getInstance().add("test_account_id", session.getId());
			session.setAttribute(SSOConfig.getLoginKey(), "test_account_id");

			result = authenticator.authenticate(request);
			assertTrue(result);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
