//
//  ElisAudioWriter.m
//  Elis Colors
//
//  Created by 柳 on 09/10/04.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisAudioWriter.h"

#define CURRENT_TIME() inFileFormat.mSampleRate

@implementation ElisAudioWriter

- (id)initWithLayer:(ElisLayer*)l
{
    layer = l;
    return self;
}

- (void)writeToFile:(NSString*)outPath
{
    
    NSString* inPath;
    
    inPath = [[layer media] path];
    
    //一度に変換するフレーム数
    UInt32 convertFrames = 256; // 1/60フレームがこれくらいのはず。
    
    //変数の宣言
    OSStatus err = noErr;
    UInt32 size;
    ExtAudioFileRef inAudioFileRef = NULL;
    ExtAudioFileRef outAudioFileRef = NULL;
    AudioStreamBasicDescription inFileFormat, ioClientFormat, outFileFormat;
    void *ioData = NULL;
    
    //読み込み側のオーディオファイルを開く（2008/6/26修正）
    //NSURL *inUrl = [NSURL URLWithString:inPath];
    NSURL *inUrl = [NSURL fileURLWithPath:inPath];
    err = ExtAudioFileOpenURL((CFURLRef)inUrl, &inAudioFileRef);
    if (err != noErr) goto catchErr;
    
    //読み込み側のオーディオファイルからフォーマットを取得する
    size = sizeof(ioClientFormat);
    err = ExtAudioFileGetProperty(
                                  inAudioFileRef, kExtAudioFileProperty_FileDataFormat, 
                                  &size, &inFileFormat);
    if (err != noErr) goto catchErr;
    
    //書き出し側のオーディオファイルのパスを作成する（2008/6/26修正）
//    NSString *outPath = 
//    [[inPath stringByDeletingPathExtension] 
//     stringByAppendingString:@"-export.wav"];
    //NSURL *outUrl = [NSURL URLWithString:outPath];
    NSURL *outUrl = [NSURL fileURLWithPath:outPath];
    
    //書き出し側のオーディオファイルのフォーマットを作成する
    outFileFormat.mSampleRate = 44100;
    outFileFormat.mFormatID = kAudioFormatLinearPCM;
    outFileFormat.mFormatFlags = 
    kAudioFormatFlagIsSignedInteger | kAudioFormatFlagIsPacked;
    outFileFormat.mBitsPerChannel = 16;
    outFileFormat.mChannelsPerFrame = inFileFormat.mChannelsPerFrame;
    outFileFormat.mFramesPerPacket = 1;
    outFileFormat.mBytesPerFrame = 
    outFileFormat.mBitsPerChannel / 8 * outFileFormat.mChannelsPerFrame;
    outFileFormat.mBytesPerPacket = 
    outFileFormat.mBytesPerFrame * outFileFormat.mFramesPerPacket;
    
    // 書き出しするファイルを削除しておく。
    [[NSFileManager defaultManager] removeFileAtPath:outPath handler:nil];
    
    //書き出し側のオーディオファイルを作成する
    err = ExtAudioFileCreateWithURL(
                                    (CFURLRef)outUrl, kAudioFileWAVEType, &outFileFormat, 
                                    NULL, 0, &outAudioFileRef);
    if (err != noErr) goto catchErr;
    
    //読み書き両方のクライアントフォーマットを設定する
    ioClientFormat.mSampleRate = inFileFormat.mSampleRate;
    ioClientFormat.mFormatID = kAudioFormatLinearPCM;
    ioClientFormat.mFormatFlags = kAudioFormatFlagsNativeFloatPacked;
    ioClientFormat.mBitsPerChannel = 32;
    ioClientFormat.mChannelsPerFrame = inFileFormat.mChannelsPerFrame;
    ioClientFormat.mFramesPerPacket = 1;
    ioClientFormat.mBytesPerFrame = 
    ioClientFormat.mBitsPerChannel / 8 * ioClientFormat.mChannelsPerFrame;
    ioClientFormat.mBytesPerPacket = 
    ioClientFormat.mBytesPerFrame * ioClientFormat.mFramesPerPacket;
    
    size = sizeof(ioClientFormat);
    err = ExtAudioFileSetProperty(
                                  outAudioFileRef, kExtAudioFileProperty_ClientDataFormat, 
                                  size, &ioClientFormat);
    if (err != noErr) goto catchErr;
    
    size = sizeof(ioClientFormat);
    err = ExtAudioFileSetProperty(
                                  inAudioFileRef, kExtAudioFileProperty_ClientDataFormat, 
                                  size, &ioClientFormat);
    if (err != noErr) goto catchErr;
    
    //オーディオデータの読み書きに使用するメモリ領域を確保する
    UInt32 allocByteSize = convertFrames * ioClientFormat.mBytesPerFrame;
    ioData = malloc(allocByteSize);
    if (!ioData) {
        err = 1002;
        goto catchErr;
    }
    memset(ioData, 0, allocByteSize);
    
    //オーディオデータの読み書きに使用するAudioBufferListを作成する
    AudioBufferList ioList;
    ioList.mNumberBuffers = 1;
    ioList.mBuffers[0].mNumberChannels = ioClientFormat.mChannelsPerFrame;
    ioList.mBuffers[0].mDataByteSize = allocByteSize;
    ioList.mBuffers[0].mData = ioData;
    
    // オフセットの分だけずらす。
    int f, startFrame, silentFrame, endFrame;
    QTTime t = [layer plusOffsetTime:QTZeroTime];
    startFrame = (float)t.timeValue/t.timeScale * inFileFormat.mSampleRate;
    
    t = [layer mapping].time;
    silentFrame = (float)t.timeValue/t.timeScale * inFileFormat.mSampleRate;
    
    t = [layer mapping].duration;
    endFrame = (float)t.timeValue/t.timeScale * inFileFormat.mSampleRate;
    
    ExtAudioFileSeek(inAudioFileRef, startFrame);
    
    //オーディオデータをコピーする
    for(f = 0; f < endFrame; f += convertFrames) {
        //フレーム数とデータサイズを設定する
        UInt32 frames = convertFrames;
        ioList.mBuffers[0].mDataByteSize = allocByteSize;
        
        //読み込み側のオーディオファイルからオーディオデータを読み込む
        if(f > silentFrame){
            err = ExtAudioFileRead(inAudioFileRef, &frames, &ioList);
            if (err != noErr) goto catchErr;
            
            int i, offset;
            float src;
//            offset = ioList.mBuffers[0].mDataByteSize/frames;
            float v = [layer getVolumeForTime:QTMakeTime(f, inFileFormat.mSampleRate)];
            for(i = 0; i < ioList.mBuffers[0].mDataByteSize; i += 4){
                src = *(float*)(ioList.mBuffers[0].mData + i);
                *(float*)(ioList.mBuffers[0].mData + i) = (float)(src*v);
            }
        }
        
        //最後まで読み込んだら終了
        if (frames == 0) break;
        
        //書き込み側のオーディオファイルへ書き込む
        err = ExtAudioFileWrite(outAudioFileRef, frames, &ioList);
        if (err != noErr) goto catchErr;
    }
    
    NSLog(@"complete");
    
    
catchErr:
    
    if (err != noErr) NSLog(@"err = %ld", err);
    
    //解放する
    if (ioData) free(ioData);
    if (inAudioFileRef) ExtAudioFileDispose(inAudioFileRef);
    if (outAudioFileRef) ExtAudioFileDispose(outAudioFileRef);
    
    return 0;
}

@end
