//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisUndoManager.m
//  Elis Colors
//
//  Created by 柳 on 09/09/24.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisUndoManager.h"


@implementation ElisUndoManager

- (void)awakeFromNib
{
    undoStack = [[NSMutableArray alloc] init];
    index = 0;
}

- (void)pushOperation:(ElisLayer*)layer
{
    NSMutableData* data = [[NSMutableData alloc] init];
    NSKeyedArchiver* encoder = [[NSKeyedArchiver alloc] initForWritingWithMutableData:data];
    
    [layer saveToEncoder:encoder];
    [encoder finishEncoding];
    
//    [undoStack addObject:layer];
//    [undoStack addObject:data];
    [undoStack removeObjectsInRange:NSMakeRange(index, [undoStack count] - index)];
    
    if(index != 0)
        if([data isEqualToData:[undoStack objectAtIndex:index-1]])
            return;
    
    [undoStack insertObject:layer atIndex:index];
    [undoStack insertObject:data atIndex:index+1];
    index += 2;
}

- (ElisLayer*)popOperation
{
    NSData* data = [undoStack objectAtIndex:index-1];
    ElisLayer* layer = [undoStack objectAtIndex:index-2];
    
    NSKeyedUnarchiver* decoder = [[NSKeyedUnarchiver alloc] initForReadingWithData:data];    
    [layer loadFromDecoder:decoder];
    [decoder finishDecoding];
    
    index -= 2;
    
    return layer;
}

- (void)redoOperation
{
    index += 4;
    [self popOperation];
}

- (BOOL)canUndo
{
    return index != 0;
    return [undoStack count] != 0;
}

- (BOOL)canRedo
{
    return index+2 < [undoStack count];
}

@end
