//
//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//  ElisLayer.h
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ElisBase.h"
#import "ElisMedia.h"
#import "ElisEffect.h"

// Elisの中核となるデータ構造。モデル。
// Old ElisのLayer+Trackに相当。

// 徐々に肥大化しつつある。どうしよう。

@interface ElisLayer : NSObject {
    ElisMedia* media;  // メディアオブジェクト
    int trackNumber;  // トラック番号。0から
    QTTimeRange mapping; // プロジェクト上の配置情報
    CALayer* alayer; // タイムラインで表示するレイヤー
    QTTime offset; // 再生時間オフセット
    NSMutableArray* effects; // エフェクトの配列
    ElisKeyframe *pxKeyframe, *pyKeyframe; // Positionのキーフレーム
    ElisKeyframe *volumeKeyframe;
    NSRect originSize; // 用意せざるをえない！
}

//@property (assign) QTTimeRange mapping; // マッピング情報。(QTTimeRange)
@property (assign) ElisMedia* media;
//@property CALayer* alayer;
//@property (assign) NSValue* offset;

- (void)changeMapping;
- (void)setAlayer:(CALayer *)layer;
- (int)trackNumber;
- (NSPoint)getPositionForTime:(QTTime)time;
- (BOOL)isInclude:(QTTime)time;
- (CIImage*)getEffectedImage:(CVTimeStamp*)timeStamp forTime:(QTTime)time;
- (void)play;
- (void)stop;
- (QTTimeRange)mapping;
- (CIImage*)getEffectedImageWithoutStamp:(QTTime)time;

- (BOOL)canChangeOffset:(float)df;
- (void)changeOffset:(float)df;
- (BOOL)canChangeMapping:(CGRect)rect;

- (CIImage*)applyEffects:(CIImage*)image forTime:(QTTime)time;
- (void)addEffect:(NSString*)name;
- (QTTime)convertToInnnerTime:(QTTime)globalTime;

- (void)createPropertyTableDataSource:(NSMutableArray*)t_effects
                             property:(NSMutableArray*)t_propertyNames
                                value:(NSMutableArray*)t_valueNames;

- (void)setPositionY:(float)y forTime:(QTTime)time;
- (void)setPositionX:(float)x forTime:(QTTime)time;

- (QTTime)plusOffsetTime:(QTTime)time;
- (void)removePositionXKeyframe;
- (void)removePositionYKerframe;

- (float)duration;
- (id)initWithCoder:(NSCoder*)coder;
- (void)encodeWithCoder:(NSCoder*)encoder;
- (void)saveToEncoder:(NSCoder*)encoder;
- (void)loadFromDecoder:(NSCoder*)coder;

- (NSSize)originSize;
- (float)speed;
- (void)setSpeed:(float)s;
- (CALayer*)alayer;

- (float)getVolumeForTime:(QTTime)time;
- (void)setVolume:(float)v forTime:(QTTime)time;
- (float)getVolumeForInnerTime:(QTTime)time;

@end
