//
//  ElisWriterDummyView.m
//  Elis Colors
//
//  Created by 柳 on 09/09/26.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ElisWriterDummyView.h"


@implementation ElisWriterDummyView

- (void)awakeFromNib
{
    lock = [[NSRecursiveLock alloc] init];
    timeOffset = QTZeroTime;
    layerSet = [[NSMutableArray alloc] init];
    sortedLayerSet = malloc(sizeof(void*) * TRACK_SIZE);
    [self prepareOpenGL];
}

- (void)finalize
{
    free(sortedLayerSet);
    [super finalize];
}

- (void)setMainController:(id)c
{
    _mainController = c;
}

- (void)prepareOpenGL
{
	GLint swapInterval = 1;
    
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);   // black background
	[[self openGLContext] setValues:&swapInterval forParameter:NSOpenGLCPSwapInterval];
    
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    ciContext = [CIContext contextWithCGLContext:[[self openGLContext] CGLContextObj]
                                     pixelFormat:[[self pixelFormat] CGLPixelFormatObj]
                                         options:[NSDictionary dictionaryWithObjectsAndKeys:(id)colorSpace, kCIContextOutputColorSpace,
                                                  (id)colorSpace, kCIContextWorkingColorSpace, nil]];
    
    CGColorSpaceRelease(colorSpace);
    
    [self setFrame:*(NSRect*)&ProjectMovieSize];
//    [self setHidden:YES];
}

- (void)getFrameForQTTime:(QTTime)time
{
    [layerSet removeAllObjects];
    _qt = time;
    [_mainController getFrameForTime:time result:layerSet];
    [self drawRect:NSZeroRect];
}

- (void)drawRect:(NSRect)rect
{
    [lock lock];
    
    [[self openGLContext] makeCurrentContext];
    glClear(GL_COLOR_BUFFER_BIT);
    
    int i, size = [layerSet count];
    CIImage* ci;
    NSPoint point;
    CGRect imageRect;
    CGPoint cp;
    
    // トラック番号順にバケットソート
    memset(sortedLayerSet, 0, sizeof(void*) * TRACK_SIZE);
    for(i = 0; i < size; i++)
        sortedLayerSet[[[layerSet objectAtIndex:i] trackNumber]] = [layerSet objectAtIndex:i];
    
    for(i = 0; i < TRACK_SIZE; i++){
        if(sortedLayerSet[i] == 0) continue;
        
        ci = [sortedLayerSet[i] getEffectedImage:nil forTime:_qt];
        point = [sortedLayerSet[i] getPositionForTime:[sortedLayerSet[i] convertToInnnerTime:_qt]];
        if(ci == nil) continue; // サウンドレイヤーはスキップ
        
        imageRect = [ci extent];
        if(imageRect.size.width >= 4000){
            imageRect = CGRectMake(0, 0, 4000, 3000);
        }
        
        cp = *(CGPoint*)&point;
        //        [ciContext drawImage:ci inRect:imageRect fromRect:CGRectMake(point.x, point.y, ProjectMovieSize.size.width, ProjectMovieSize.size.height)];
        [ciContext drawImage:ci atPoint:cp fromRect:imageRect];
        //        [ciContext drawImage:ci inRect:CGRectMake(point.x, point.y, imageRect.size.width, imageRect.size.height)
        //                    fromRect:imageRect];
    }
    
    glFlush();
    
    // あとかたづけ
    for(i = 0; i < size; i++)
        [[layerSet objectAtIndex:i] releaseContext];
    
    [layerSet removeAllObjects];
    
    [lock unlock];
}

- (void)reshape
{ 
	GLfloat minX, minY, maxX, maxY;
    
    NSRect sceneBounds = [self bounds];
 	NSRect frame = [self frame];
	
    minX = NSMinX(sceneBounds);
	minY = NSMinY(sceneBounds);
	maxX = NSMaxX(sceneBounds);
	maxY = NSMaxY(sceneBounds);
    
    //    if(rendering)
    //        glViewport(0, 0, (GLsizei)ProjectMovieSize.size.width, (GLsizei)ProjectMovieSize.size.height);
    //    else
    glViewport(0, 0, (GLsizei)frame.size.width, (GLsizei)frame.size.height);	// set the viewport
    
    glMatrixMode(GL_MODELVIEW);    // select the modelview matrix
    glLoadIdentity();              // reset it
    
    glMatrixMode(GL_PROJECTION);   // select the projection matrix
    glLoadIdentity();              // reset it
    
    //    if(rendering)
    //        gluOrtho2D(minX, minX + ProjectMovieSize.size.width, minY, minY + ProjectMovieSize.size.height);
    //    else
    gluOrtho2D(minX, maxX, minY, maxY);	// define a 2-D orthographic projection matrix
    
    //    float scale;
    //    if(frame.size.height < frame.size.width)
    //        scale = frame.size.height/ProjectMovieSize.size.height;
    //    else 
    //        scale = frame.size.width/ProjectMovieSize.size.width;
    
    //    glScalef(scale, scale, 1.0);
    
	glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    
}

- (void)getCurrentPixelData:(NSRect)rect buffer:(void*)buffer
{
    glPushClientAttrib(GL_CLIENT_PIXEL_STORE_BIT);
    glPixelStorei(GL_PACK_ALIGNMENT, 4);	
    glPixelStorei(GL_PACK_ROW_LENGTH, 0);
    glPixelStorei(GL_PACK_SKIP_ROWS, 0);
    glPixelStorei(GL_PACK_SKIP_PIXELS, 0);
    
    //    glReadBuffer(GL_FRONT); // フロントバッファ（って何だろう？）からピクセルを読みに行く。
    glReadPixels(0, 0, rect.size.width, rect.size.height, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, buffer);
    
    glPopClientAttrib();
}


@end
