/*
 * $Id: AnswerActivity.java 14 2011-08-21 10:02:23Z lailai $
 */

package net.lailai.android.english.word.learning;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class AnswerActivity extends Activity {

	/* ( Javadoc)
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.answer);

		// intent擾
		Bundle extras = getIntent().getExtras();
		final String number = (String)extras.getCharSequence("QUESTION_NO");

		// ʂԍ
		TextView QNo = (TextView)findViewById(R.id.textView1);
		QNo.setText(number + ".");

		// у{^
		Button Score = (Button)findViewById(R.id.button1);
		Score.setText("");
		Score.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(AnswerActivity.this, ScoreActivity.class);
				intent.putExtra("QUESTION_NO", number);
				startActivity(intent);
			}
		});

		// 
		TextView QJa = (TextView)findViewById(R.id.textView2);
		QJa.setTextSize(40.0f);
		QJa.setText(EnglishWord.getJa(number));

		// 
		TextView Arrow = (TextView)findViewById(R.id.textView3);
		Arrow.setTextSize(40.0f);
		Arrow.setText("");

		// 
		TextView A = (TextView)findViewById(R.id.textView4);
		A.setTextSize(40.0f);
		A.setText(EnglishWord.getEn(number));

		// ł
		Button Correct = (Button)findViewById(R.id.button2);
		Correct.setText("ł");
		Correct.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				setResult(RESULT_OK);
				finish();
			}
		});

		// łȂ
		Button Fault = (Button)findViewById(R.id.button3);
		Fault.setText("łȂ");
		Fault.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				setResult(RESULT_CANCELED);
				finish();
			}
		});
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.menu, menu);
		return true;
	}

	/* ( Javadoc)
	 * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		super.onOptionsItemSelected(item);
		switch (item.getItemId()) {
		case R.id.clear:
			popupConfirmScoreClear();
			return true;
		case R.id.help:
			Intent intent = new Intent(AnswerActivity.this, HelpActivity.class);
			startActivity(intent);
			return true;
		case R.id.exit:
			moveTaskToBack(true);
		default:
			break;
		}
		return false;
	}

	public void popupConfirmScoreClear() {
		AlertDialog.Builder adb = new AlertDialog.Builder(this);
		adb.setTitle(R.string.warning);
		adb.setMessage(R.string.confirm_score_clear);
		adb.setIcon(android.R.drawable.ic_dialog_alert);
		adb.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				clearPreference();
			}
		});
		adb.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
			}
		});
		adb.show();
	}

	private void loadPreference() {
		PlayData.clearData();
		SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(PlayData.getContext());
		for (int i = 0; i < EnglishWord.getWordCount(); i++) {
			PlayData.setScore(i, sharedPreferences.getString(String.valueOf(i + 1), "0"));
			if (!PlayData.getScore(i).equals("2")) {
				PlayData.addData(new Integer(i + 1));
			}
		}
	}

	private void clearPreference() {
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(PlayData.getContext());
		Editor ed = sp.edit();
		for (int i = 0 ; i < EnglishWord.getWordCount(); i++) {
			ed.putString(String.valueOf(i + 1), "0");
		}
		ed.commit();
		loadPreference();
	}
}
