/*
 * $Id: PlayData.java 11 2011-08-20 22:48:31Z lailai $
 */

package net.lailai.android.english.word.learning;

import java.util.ArrayList;

import android.content.Context;

public class PlayData {
	private static ArrayList<Integer> playQuestion = new ArrayList<Integer>();
	private static String[] score = null;
	private static Context PreferenceContext = null;
	private static int mCurrentQuestion = 0;

	public static void addData(Integer data) {
		playQuestion.add(data);
	}

	public static Integer getData(int index) {
		return playQuestion.get(index);
	}

	public static int getDataIndex(Integer data) {
		return playQuestion.indexOf(data);
	}

	public static void removeData(int index) {
		playQuestion.remove(index);
	}

	public static int getDataSize() {
		return playQuestion.size();
	}

	public static void clearData() {
		playQuestion = new ArrayList<Integer>();
	}

	public static void setScore(int index, String scoreData) {
		if (score == null) {
			score = new String[EnglishWord.getWordCount()];
			for (int i = 0; i < EnglishWord.getWordCount(); i++) {
				score[i] = "0";
			}
		}
		score[index] = scoreData;
	}

	public static String getScore(int index) {
		return score[index];
	}

	public static void setContext(Context context) {
		PreferenceContext = context;
	}

	public static Context getContext() {
		return PreferenceContext;
	}

	public static void setCurrentQuestion(int qNo) {
		mCurrentQuestion = qNo;
	}

	public static int getCurrentQuestion() {
		return mCurrentQuestion;
	}
}
