#!/bin/bash
#### 
WD=`pwd`


if [ -z $EOS_HOME0 ] ; then
	EOS_HOME0=$HOME/Eos
fi

echo "Set the directroy to be installed [$EOS_HOME0]: "; read ANS
if [ ! -z $ANS ] ; then 
	EOS_HOME0=$ANS;
else 
	EOS_HOME0=$HOME/Eos; 
fi
unset ANS
echo "Directory: $EOS_HOME0";

#### No Change
#ROOT_EOS_SOURCEFORGE=https://sourceforge.jp/projects/eos/scm/git/base/blobs/master/
ROOT_EOS_OSDN_GIT=git://git.osdn.jp/gitroot/eos/base.git
ROOT_EOS_OSDN_HTTP=http://scm.osdn.jp/gitroot/eos/base.git
ROOT_EOS_OSDN_SSH=${EOS_GITUSER}@git.osdn.jp:/gitroot/eos/base.git
ROOT_EOS_OSDN_HTTPS=https://scm.osdn.jp/gitroot/eos/base.git

if [ ! -d $EOS_HOME0 ] ; then
	mkdir $EOS_HOME0
fi

#curl -L $ROOT_EOS_SOURCEFORGE/env/Eos_env?export=raw | sh - ; 

if [ -d $EOS_HOME0/.git ] ; then
	echo "Already installed"
	echo "Use update-eos.sh for updating or set a new directory for installation"
else
	if [ -z $EOS_GITUSER ] ; then
		INSTALL_FLAG=
	else 
		git clone --depth 1 $ROOT_EOS_OSDN_SSH $EOS_HOME0 || \
		git clone --depth 1 $ROOT_EOS_OSDN_HTTPS $EOS_HOME0 || \
		echo "A port for SSH or HTTPS is not open, or something wrong for $EOS_GITUSER."
		INSTALL_FLAG=INSTALL
	fi
	if [ -z $INSTALL_FLAG ] ; then
		git clone --depth 1 $ROOT_EOS_OSDN_GIT  $EOS_HOME0 || \
		git clone --depth 1 $ROOT_EOS_OSDN_HTTP $EOS_HOME0 || \
		echo "A port for git (9418) or HTTP is not open, or something wrong."
	fi
fi


if [ -z $EOS_HOME0 ] ; then
	export EOS_HOME0=$HOME/Eos
fi
cat >> $HOME/.bashrc << EOF

##
## Eos_env
##

if [ ! -z $EOS_HOME0 ] ; then 
if [ -f $EOS_HOME0/env/Eos_env -a ! -f $HOME/.Eos_env ] ; then
	ln -s $EOS_HOME0/env/Eos_env $HOME/.Eos_env
fi
fi

test -r $HOME/.Eos_env  && . $HOME/.Eos_env

EOF

#
# hostdepend
#

if [ ! -f $HOME/.Eos_env ] ; then
	echo "No .Eos_env"
	ln -sf $EOS_HOME0/env/Eos_env $HOME/.Eos_env 
fi

source ~/.Eos_env || echo "Prepare environment"
echo "hostdepend for ${EOS_HOSTDIR}"

HOSTDEPEND_EOS_OSDN_GIT=git://git.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_HTTP=http://scm.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_SSH=${EOS_GITUSER}@git.osdn.jp:/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_HTTPS=https://scm.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git

if [ ! -d $EOS_HOME0/hostdepend ] ; then
	mkdir $EOS_HOME0/hostdepend	
fi	

if [ -d $EOS_HOME0/hostdepend ] ; then
	cd $EOS_HOME0/hostdepend/;  
	if [ -d ${EOS_HOSTDIR}/.git ] ; then
		echo "Already installed hostdepend/${EOS_HOSTDIR}"; 
		echo "Use update-eos.sh for updating or set a new directory for installation"
	else 
		if [ -z $EOS_GITUSER ] ; then
			INSTALL_FLAG=
		else 
			git clone --depth 1 ${HOSTDEPEND_EOS_OSDN_SSH} ${EOS_HOSTDIR} || \
			git clone --depth 1 ${HOSTDEPEND_EOS_OSDN_HTTPS} ${EOS_HOSTDIR} || \
			echo "A port for SSH or HTTPS is not open, or something wrong."
			INSTALL_FLAG=INSTALL
		fi
		if [ -z $INSTALL_FLAG ] ; then
			git clone --depth 1 ${HOSTDEPEND_EOS_OSDN_GIT} ${EOS_HOSTDIR} || \
			git clone --depth 1 ${HOSTDEPEND_EOS_OSDN_HTTP} ${EOS_HOSTDIR} || \
			echo "A port for git (9418) or HTTP is not open, or something wrong."
		fi
	fi
else
	echo "Cannot make hostdepend"
fi

cd $WD
