#!/bin/sh
WD=`pwd`

if [ -z $EOS_HOME ] ; then
	echo "Please set an environment for Eos using $source env/Eos_env."
	exit
fi

ROOT_EOS_OSDN_GIT=git://git.osdn.jp/gitroot/eos/base.git
ROOT_EOS_OSDN_HTTP=http://scm.osdn.jp/gitroot/eos/base.git
ROOT_EOS_OSDN_SSH=${EOS_GITUSER}@git.osdn.jp:/gitroot/eos/base.git
ROOT_EOS_OSDN_HTTPS=https://scm.osdn.jp/gitroot/eos/base.git

if [ ! -d $EOS_HOME/.git ] ; then
	echo "Not installed"
	echo "Use install-eos.sh for updating or make concern env of EOS_HOME. Current var is $EOS_HOME."
else
	if [ -z $EOS_GITUSER ] ; then
		INSTALL_FLAG=
	else
		cd $EOS_HOME; echo "$EOS_GITUSER as EOS_GITUSER";  
		git pull $ROOT_EOS_OSDN_SSH || \
		git pull --depth 1 $ROOT_EOS_OSDN_HTTPS || \
			echo "A port for SSH or HTTPS is not open, or something wrong for $EOS_GITUSER."
			INSTALL_FLAG=INSTALL
	fi
	if [ -z $NOT_INSTALL ] ; then
		cd $EOS_HOME; echo "No EOS_GITUSER."; 
		git pull $ROOT_EOS_OSDN_GIT  || \
		git pull $ROOT_EOS_OSDN_HTTP || \
		echo "A port for git (9418) or HTTP is not open, or something wrong."
	fi
fi

if [ -z ${EOS_HOSTDIR} ] ; then
	echo "Set EOS_HOSTDIR. Current is $EOS_HOSTDIR";
	exit;
else
	echo "hostdepend for ${EOS_HOSTDIR}"
fi

HOSTDEPEND_EOS_OSDN_GIT=git://git.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_HTTP=http://scm.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_SSH=${EOS_GITUSER}@git.osdn.jp:/gitroot/eos/hostdepend${EOS_HOSTDIR}.git
HOSTDEPEND_EOS_OSDN_HTTPS=https://scm.osdn.jp/gitroot/eos/hostdepend${EOS_HOSTDIR}.git

if [ -d $EOS_HOME/hostdepend ] ; then
    cd $EOS_HOME/hostdepend/;  
    if [ ! -d ${EOS_HOSTDIR}/.git ] ; then
        echo "Not installed hostdepend/${EOS_HOSTDIR}"; 
        echo "Use install-eos.sh for updating or set a new directory for update"
    else 
        if [ -z $EOS_GITUSER ] ; then
            INSTALL_FLAG=
        else 
			cd ${EOS_HOSTDIR}
            git pull ${HOSTDEPEND_EOS_OSDN_SSH}   || \
            git pull ${HOSTDEPEND_EOS_OSDN_HTTPS} || \
            echo "A port for SSH or HTTPS is not open, or something wrong."
            INSTALL_FLAG=INSTALL
        fi  
        if [ -z $NOT_INSTALL ] ; then
            git pull ${HOSTDEPEND_EOS_OSDN_GIT}  || \
            git pull ${HOSTDEPEND_EOS_OSDN_HTTP} || \
            echo "A port for git (9418) or HTTP is not open, or something wrong."
        fi  
    fi  
else
    echo "No hostdepend dir"
fi

cd $WD
