/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrc2bild ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrc2bild 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrc2bild ver%I%; Date:%D% %Z%";

#include "../inc/bildFile.h"

void
lmrc2bildUsage(FILE* fpt)
{
	fprintf(fpt, "%d: Arrows\n", lmrc2bildModeArrows);
	fprintf(fpt, "%d: Spheres\n", lmrc2bildModeSpheres);
}

void
lmrc2bild(FILE* fpt, mrcImage* in, lmrc2bildInfo linfo, int mode)
{
	switch(mode) {
		case lmrc2bildModeArrows: {
			lmrc2bildArrows(fpt, in, linfo, mode);
			break;
		}
		case lmrc2bildModeSpheres: {
			lmrc2bildSpheres(fpt, in, linfo, mode);
			break;
		}
	}
}


void
lmrc2bildArrows(FILE* fpt, mrcImage* in, lmrc2bildInfo linfo, int mode)
{
	mrcImageParaTypeReal x, y, z;
	mrcImageParaTypeReal startx, starty, startz;
	mrcImageParaTypeReal endx, endy, endz;
	double d0, d1, d2;

	fprintf(fpt, ".color %g %g %g\n", linfo.color[0], linfo.color[1], linfo.color[2]);
	for(z=0; z<in[0].HeaderN.z; z++) {
	for(y=0; y<in[0].HeaderN.y; y++) {
	for(x=0; x<in[0].HeaderN.x; x++) {
		mrcPixelDataGet(&in[0], x, y, z, &d0, mrcPixelRePart, mrcPixelHowNearest);
		mrcPixelDataGet(&in[1], x, y, z, &d1, mrcPixelRePart, mrcPixelHowNearest);
		mrcPixelDataGet(&in[2], x, y, z, &d2, mrcPixelRePart, mrcPixelHowNearest);
		if(d0==0 && d1==0 && d2==0) {
		} else {
			startx = (x+in[0].HeaderStartN.x)*in[0].HeaderLength.x; 
			starty = (y+in[0].HeaderStartN.y)*in[0].HeaderLength.y; 
			startz = (z+in[0].HeaderStartN.z)*in[0].HeaderLength.z; 
			endx   = startx + d0*in[0].HeaderLength.x*linfo.zoom;
			endy   = starty + d1*in[1].HeaderLength.y*linfo.zoom;
			endz   = startz + d2*in[2].HeaderLength.z*linfo.zoom;
			fprintf(fpt, ".arrow %g %g %g %g %g %g %g %g %g\n", startx, starty, startz,
																endx,   endy,   endz,
																linfo.r1, linfo.r2, linfo.rho);
		}
	}
	}
	}
}


void
lmrc2bildSpheres(FILE* fpt, mrcImage* in, lmrc2bildInfo linfo, int mode)
{
	mrcImageParaTypeReal x, y, z;
	mrcImageParaTypeReal startx, starty, startz;
	mrcImageParaTypeReal endx, endy, endz;
	double d0, d1, d2;

	fprintf(fpt, ".color %g %g %g\n", linfo.color[0], linfo.color[1], linfo.color[2]);
	for(z=0; z<in[0].HeaderN.z; z++) {
	for(y=0; y<in[0].HeaderN.y; y++) {
	for(x=0; x<in[0].HeaderN.x; x++) {
		mrcPixelDataGet(&in[0], x, y, z, &d0, mrcPixelRePart, mrcPixelHowNearest);
		if(d0==0 && d1==0 && d2==0) {
		} else {
			startx = (x+in[0].HeaderStartN.x)*in[0].HeaderLength.x; 
			starty = (y+in[0].HeaderStartN.y)*in[0].HeaderLength.y; 
			startz = (z+in[0].HeaderStartN.z)*in[0].HeaderLength.z; 
			fprintf(fpt, ".sphere %g %g %g %g\n", startx
										     , starty
											 , startz
											 ,d0*in[0].HeaderLength.x*linfo.zoom);
		}
	}
	}
	}
}


