/*
# pgJournalSelectCORBAClient : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : pgJournalSelectCORBAClient
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "CORBA.h"
#include <pgsql/libpq-fe.h>
#include "Memory.h"
#include "DataBaseCorba.h"
#include <fstream.h>
#include <iostream>
using namespace std;
#include <unistd.h>
#include <coss/CosNaming.h>

#ifdef _WIN32
#include <direct.h>
#endif


/*
Example:
typedef struct lpgJournalSelectCORBAClientInfo {
	float a;
	int   b;
} lpgJournalSelectCORBAClientInfo;

typedef enum lpgJournalSelectCORBAClientMode {
	a=0,
	b=1
} lpgJournalSelectCORBAClientMode;
*/

int
main(int argc, char* argv[]) 
{
	pgJournalSelectCORBAClientInfo info;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	
	//ORB initialization
	CORBA::ORB_var orb = CORBA::ORB_init(argc,argv);

	CORBA::Object_var nsobj = orb->resolve_initial_references("NameService");

	CosNaming::NamingContext_var nc = CosNaming::NamingContext::_narrow (nsobj);

	if(CORBA::is_nil(nc)){
	cerr<<"oops, I cannot access the Naming Service!" << endl;
	exit(1);
	}

	
	int database=0;
	printf("1:Journal 2:Memo---->>");
	scanf("%d",&database);
	char* databasename;
	databasename= (char *)memoryAllocate(sizeof(char)*300,"main");

	switch(database){
	case 1:
	databasename="Journal";
	break;
	case 2:
	databasename="Memo";
	break;
	}

 	CosNaming::Name name;
	name.length(1);
	name[0].id = CORBA::string_dup(databasename);
	name[0].kind = CORBA::string_dup("");

	CORBA::Object_var obj;
	cout<< "Looking up Journal ..."<<flush;

	#ifdef HAVE_EXCEPTIONS
	try{
	obj = nc->resolve(name);
	}
	catch (CosNaming::NamingContext::NotFound &exc){
	cout <<"NotFound exception." <<endl;
	exit(1);
	}

	catch (CosNaming::NamingContext::CannotProceed &exc){	
	cout <<"CannotProceed exception"<<endl;
	exit(1);
	}
	
 	catch(CosNaming::NamingContext::InvalidName &exc){
	cout <<"InvalidName exception."<<endl;
	exit(1);
	}

	#else
	 obj = nc->resolve(name);
	#endif

	cout<<"done!"<<endl;

//	Bank_var bank=Bank::_narrow(obj);

	DataBaseCorba_var DataBaseCorba=DataBaseCorba::_narrow(obj);
	
	if(CORBA::is_nil(DataBaseCorba)){
	printf("oops: DataBaseCorba is nil\n");
	exit(1);
	}

 	

	printf("client start.\n");
	char* sql;
	sql = (char*)memoryAllocate(sizeof(char)*300,"main");
	char* PDBcord;
	char* Residues;
	PDBcord=(char *)memoryAllocate(sizeof(char)*300,"main");
        Residues=(char *)memoryAllocate(sizeof(char)*300,"main");
	int mode=0;

	Result_slice *Result_alloc();
	Result_slice *result=Result_alloc();
	
	CORBA::Long i=0;
	int j;
	char* dummy="dummy";
	result[0][0]=dummy;
	printf("Input PDBCord --->>");
       	scanf("%s",PDBcord);
        printf("Input Residues--->>");
        scanf("%s",Residues);

	printf("1:Show 2:Insert---->>");
	scanf("%d",&mode);
	
	cout<<databasename<<endl;
	
	switch(mode){
	case 1:
	 	if(databasename=="Journal"){
		sprintf(sql,"SELECT Title,Authors,Journal,Vol FROM %s WHERE  pdbcord='%s' and resnum='%s'",databasename,PDBcord,Residues);
		}
		else if(databasename=="Memo"){
		sprintf(sql,"SELECT Memo,Resnum FROM %s WHERE  pdbcord='%s' and resnum='%s'",databasename,PDBcord,Residues);
		}
		cout<<sql<<endl;	
		DataBaseCorba->SetKey(sql);
		cout<<result[0][0]<<endl;
		while(*result[0][0]!=NULL){
			cout<<endl<<"------------------------------------------------------------------------------------------------------------------------------------------------------------------------------"<<endl;
	
//			result=Result_dup(DataBaseCorba->Display(i));
			result=DataBaseCorba->Display(i);
		 	for (j=0;j<9;j++){
			cout<<result[0][j];
			}
		i++;
		cout<<result[0][0]<<endl;
		}
	break;	
	
	case 2:
		char check;
		string Title;
		char* title;
		char* authors;
		char* Journal;
		char* vol;
		title=(char *)memoryAllocate(sizeof(char)*300,"main");
		authors=(char *)memoryAllocate(sizeof(char)*300,"main");
		Journal=(char *)memoryAllocate(sizeof(char)*300,"main");
		vol=(char *)memoryAllocate(sizeof(char)*300,"main");
		printf("Insert? -->>(y/n)");
		cin>>check;
		if(check=='y'){
			switch(database){
			case 1:
			cout<<"Title-->";
			cin.get(title,300);
//			cout<<title<<flush;
			cout<<"Authors-->";
			cin>>authors;
			cout<<"Journal-->";
			cin>>Journal;
			cout<<"Volume-->";
			cin>>vol;
			sprintf(sql,"SELECT * FROM %s WHERE pdbcord='%s' and resnum='%s' and title='%s'",databasename,PDBcord,Residues,title);
			cout <<sql<<endl;	
			DataBaseCorba->SetKey(sql);
//			result=Result_dup(DataBaseCorba->Display(1));
			result=DataBaseCorba->Display(1);
			if(*result[0][0]!=NULL){
				cout<<"It is already registered"<<endl;
			}
			else{
			sprintf(sql,"SELECT MAX(ID) FROM journal");
			DataBaseCorba->SetKey(sql);
//			result=Result_dup(DataBaseCorba->Display(0));
			cout<<*result[0][0]<<endl;
			int ID;
			ID=(int)CORBA::string_dup(result[0][0]);
			sprintf(sql,"INSERT INTO Journal VALUES(%d,'%s','%s','%s','%s','%s','%s'",ID+1,title,Journal,authors,vol,PDBcord,Residues);
			DataBaseCorba->SetKey(sql);
	
			}
		}
	}
	else{	
	break;
	}
	break;	
		
	}

	Result_free(result);
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
