#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      ).as(inFile::mrcImage    ) ] :Essential :Input: mrcImage\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      ).as(outFile::mrcImage   ) ] :Essential :Output: mrcImage:area\n");
    fprintf(stderr, "    [-O[utput]           OutInfo             (stdout    ).as(outFile::ASCII      ) ] :Optional  :Output: ASCII: area info\n");
    fprintf(stderr, "    [-l[abel]            Label               (NULL      ).as(outFile::mrcImage   ) ] :Optional  :Output: mrcImage:labeling\n");
    fprintf(stderr, "    [-O[utput]H[istgram] OutHist             (NULL      ).as(outFile::ASCII      ) ] :Optional  :Output: ASCII: area info\n");
    fprintf(stderr, "    [-H[istgram]         DelHist             (1         ).as(Real                ) ] :Optional  :Delta\n");
    fprintf(stderr, "    [-N[eighbor]         Neighbor            (0         ).as(Real                ) ] :Optional  :Neighbor\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      ).as(inFile              ) ] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         ).as(Integer             ) ] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
