/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% ldm2mrc ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : ldm2mrc 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%ldm2mrc ver%I%; Date:%D% %Z%";
#include <stdio.h>
#include <stdlib.h>
#define DEBUG
#include "genUtil.h"
#include "../inc/dmFile.h"

void
ldm2mrc(mrcImage* mrc, dmFile* dm, int mode)
{
	switch(dm->version) {
		case 3: {
			dmFile3TagDirectory2mrc(dm, dm->RootTag3, 0, mode);
			break;
		}
		case 4: {
			dmFile4TagDirectory2mrc(dm, dm->RootTag4, 0, mode);
			break;
		}
		default: {
			fprintf(stderr, "%d: Not supported version\n", dm->version);
			break;
		}

	}
}

void
dmFile3TagDirectory2mrc(dmFile* dm, dmFile3TagDirectory tagDir, int layer, int mode)
{
	int i, j, k;
	char nest[1024];
	dmFile3TagDirectory* curDir; 
	mrcImage* curImage;

	//fprintf(fpt, "%snumberOfTags: %lld\n", nest, tagDir.numberOfTags);
	for(i=0; i<tagDir.numberOfTags; i++) {
		if(0<tagDir.Tags[i].tagNameLength) {
			// ImageList
			if(0==strncmp("ImageList", tagDir.Tags[i].tagName, tagDir.Tags[i].tagNameLength)) {
				for(j=0; j<tagDir.Tags[i].tagDir->numberOfTags; j++) { 
					fprintf(stderr, "-%d: %s\n", j, tagDir.Tags[i].tagDir->Tags[j].tagName); 
					for(k=0; k<tagDir.Tags[i].tagDir->Tags[j].tagDir->numberOfTags; k++) { 
						fprintf(stderr, "--%d: %s\n", j, tagDir.Tags[i].tagDir->Tags[j].tagDir->Tags[k].tagName); 
					}
				}
				// ImageData	
				switch(mode) {
					case 0: { // Raw Images
						if(0==strncmp("ImageData", tagDir.Tags[i].tagDir->Tags[1].tagDir->Tags[0].tagName, tagDir.Tags[i].tagDir->Tags[1].tagDir->Tags[0].tagNameLength)) {
							curDir = tagDir.Tags[i].tagDir->Tags[1].tagDir->Tags[0].tagDir;
							curImage = &dm->image;
						} else {
							fprintf(stderr, "Something wrong\n");
							exit(EXIT_FAILURE);
						}
						break;
					}
					case 1: { // Thumnail
						if(0==strncmp("ImageData", tagDir.Tags[i].tagDir->Tags[0].tagDir->Tags[0].tagName, tagDir.Tags[i].tagDir->Tags[0].tagDir->Tags[0].tagNameLength)) {
							curDir = tagDir.Tags[i].tagDir->Tags[0].tagDir->Tags[0].tagDir;
							curImage = &dm->thumnail;
						} else {
							fprintf(stderr, "Something wrong\n");
							exit(EXIT_FAILURE);
						}
						break;
					}
				}
				for(j=0; j<curDir->numberOfTags; j++) { 			
					DEBUGPRINT2("%d: %s\n", j, curDir->Tags[j].tagName);
					SSWITCH(curDir->Tags[j].tagName)
						SCASE("Dimensions") {
							//curImage->HeaderN.x = curDir->Tags[j].tagDir->Tags[0];			
							//curImage->HeaderN.y = curDir->Tags[j].tagDir->Tags[1];				
							//curImage->HeaderN.z = 1; 				
							SBREAK;
						}
						SDEFAULT {
						}
					SSWITCHEND	

					//curImage->HeaderN.x =  				
					//curImage->HeaderN.y = 				
					//curImage->HeaderN.z = 				

				}	
				return;
			}
		}
	}
}

void
dmFile4TagDirectory2mrc(dmFile* dm, dmFile4TagDirectory tagDir, int layer, int mode)
{

	int i;
	char nest[1024];

	//fprintf(fpt, "%snumberOfTags: %lld\n", nest, tagDir.numberOfTags);

	for(i=0; i<tagDir.numberOfTags; i++) {
		if(0<tagDir.Tags[i].tagNameLength) {
			if(0==strncmp("ImageList", tagDir.Tags[i].tagName, tagDir.Tags[i].tagNameLength)) {
				// Thumnail
				fprintf(stderr, "%s\n", tagDir.Tags[i].tagDir->Tags[0].tagDir->Tags[0].tagName);

				// Raw Images
				fprintf(stderr, "%s\n", tagDir.Tags[i].tagDir->Tags[1].tagDir->Tags[0].tagName);
				return;
			}
		}
	}
}

