/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% larray2mrc ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : larray2mrc 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%larray2mrc ver%I%; Date:%D% %Z%";


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  

#define DEBUG
#include "genUtil.h"
#include "Array.h"
#include "mrcImage.h"
#include "larray2mrc.h"

void 
larray2mrc(mrcImage* out, Array array, larray2mrcInfo* linfo, int mode)
{
	int i, j, k;

	mrcDefaultHeaderValueSet(out);	
	out->HeaderMode = linfo->mrcMode;
	switch(array.dim){
		case 1 :
			out->HeaderLength.x = out->HeaderLength.y = out->HeaderLength.z = linfo->mrcLength;
			out->HeaderN.x = (int)array.n[0];
			out->HeaderN.y = 0;
			out->HeaderN.z = 0;
			break;
		case 2 :
			out->HeaderLength.x = out->HeaderLength.y = out->HeaderLength.z = linfo->mrcLength;
			out->HeaderN.x = (int)array.n[0];
			out->HeaderN.y = (int)array.n[1];
			out->HeaderN.z = 0;
			break;
		case 3 :
			out->HeaderLength.x = out->HeaderLength.y = out->HeaderLength.z = linfo->mrcLength;
			out->HeaderN.x = (int)array.n[0];
			out->HeaderN.y = (int)array.n[1];
			out->HeaderN.z = (int)array.n[2];
			break;
		default: {
			fprintf(stderr, "Not supported array.dim in larray2mrc: %ld\n", array.dim);
		}
	}	
	mrcInit(out, NULL);


	switch(array.dim){
		case 1:
			for(j=0; j<array.n[0]; j++){
				mrcPixelDataSet(out, j, 0, 0, array.A[j], mrcPixelRePart);
			}
			break;
		case 2:
			for(i=0; i<array.n[1]; i++){
			for(j=0; j<array.n[0]; j++){
				mrcPixelDataSet(out, j, i, 0, array.A[j+i*array.n[0]], mrcPixelRePart);
			}
			}
			break;
		case 3:
			for(k=0; k<array.n[2]; k++){
			for(i=0; i<array.n[1]; i++){
			for(j=0; j<array.n[0]; j++){
				mrcPixelDataSet(out, j, i, k, array.A[j+i*array.n[0]+k*array.n[0]*array.n[1]], mrcPixelRePart);
			}
			}
			}
			break;
	}
}
