#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      ).as(inFile              ) ] :Essential :Input: mrcImage\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      ).as(outFile             ) ] :Essential :Output: mrcImage\n");
    fprintf(stderr, "    [-center             cx                  (0         ).as(Real                ) \n                         cy                  (0         ).as(Real                ) \n                         cz                  (0         ).as(Real                ) ] :Optional  :Center:\n");
    fprintf(stderr, "    [-w[idth]            wx                  (0         ).as(Real                ) \n                         wy                  (0         ).as(Real                ) \n                         wz                  (0         ).as(Real                ) ] :Optional  :Width\n");
    fprintf(stderr, "    [-r[dius]            r                   (0         ).as(Real                ) ] :Optional  :Radius\n");
    fprintf(stderr, "    [-w[idth]r[dius]     w                   (0         ).as(Real                ) ] :Optional  :Width for R\n");
    fprintf(stderr, "    [-w[idth]z           widthz              (0         ).as(Real                ) ] :Optional  :Width for z\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      ).as(inFile              ) ] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         ).as(Integer             ) ] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
