#ifndef EOS_BAYES_H
#define EOS_BAYES_H

typedef struct eosBayesDistribution {
	float min;
	float max;
	float delta;
	int   n;
	float* prob;
} eosBayesDistribution;

 
typedef struct eosBayes {
	int numDistribution;
	eosBayesDistribution* prior;
	eosBayesDistribution* posterior;

	int numLikelihood;
	eosBayesDistribution* likelihood;
} eosBayes;


typedef enum eosBayesDistributionInfoMode {
	 eosBayesDistributionInfoModeGaussian=0

}  eosBayesDistributionInfoMode; 

typedef struct eosBayesDistributionInfo {
	float min;
	float max;
	float delta;


	 eosBayesDistributionInfoMode mode;


	// For Gaussian
	float mean;
	float sigma;
} eosBayesDistributionInfo;


/* eosBayesInit.c */
// Initialization of eosBays
extern void eosBayesInit(eosBayes* b, int numDistribution, int numLikelihood, int mode);

// Initialize Each distribution of eosBayesDistributions
extern void eosBayesDistributionInit(eosBayesDistributions* d, float min, float max, float delta, int mode);

// Initialize probe of Each distribution of eosBayesDistriubutions
extern void eosBayesDistributionInitialProbabilitySet(eosBayesDistribution* d, int mode);

/* eosBayesEstimation.c */
extern void eosBayesEstimation(eosBayesDistribution* d, int mode);

/* eosBayesWrite.c */
extern void eosBayesDistribututionWrite(FILE* fpt, eosBayesDistribution* d, int mode);
extern void eosBayesPriorWrite(FILE* fpt, eosBayes* d, int mode);
extern void eosBayesPosterior(FILE* fpt, eosBayes* d, int mode);
extern void eosBayesLikelihood(FILE* fpt, eosBayes* d, int mode);
extern void eosBayesWrite(FILE* fpt, eosBayes* d, int mode);
// FileFormat
// 0 min0 max0 delta0 n0 out.prior[0].prob[0] ...... prob[n-1]
// 1 min1 max1 delta1 n1 out.prior[1].prob[0] ...... prob[n-1]



/* eosBayesRead.c */
extern void eosBayesDistributionRead(FILE* fpt, eosBayesDistribution* d, int mode);
extern void eosBayesRead(FILE* fpt, eosBayes* d, int mode);


#endif /* EOS_BAYES_H */
