'use strict';

angular.module('zephyrApp')
.controller('WorkspacepageCtrl', function ($scope, $location, directivePath, createDirModal, createFileModal, api) {
    //$scope.navbar = directivePath.navbar;
    $scope.tableRows = [];

    if ($location.path() == "/workspacePage/all") {
        $scope.path    = "All Workspace";
        $scope.isAll   = true;
        $scope.isChild = false;
    } else {
        $scope.path    = $location.path().replace("/workspacePage/","");
        $scope.isAll   = false;
        $scope.isChild = true;
    }

    $scope.openDirModal = function () {
        createDirModal.open($scope);
    };

    $scope.openFileModal = function () {
        createFileModal.open($scope);
    };


    $scope.update = function () {
        $scope.tableRows = [];
        if ($scope.isAll) {
            api('workspace/update');
            var dirs = api('workspace/read');
            dirs.$promise.then(function () {
                angular.forEach(dirs, function (dir) {
                    $scope.tableRows.push(dir);
                });
            });
        } else {
            api('upload/update/'+$scope.path);
            var files = api('upload/read/'+$scope.path);
            files.$promise.then(function () {
                console.log(files);
                angular.forEach(files, function (file) {
                    $scope.tableRows.push(file);
                });
            });
        }
    }

    $scope.update();

    $scope.move = function (path) {
        $location.path('workspacePage/'+path); 
    }

});

function Table(info) {
    var row = {
        name: info,
        size: info,
        created_time: info
    };
    return row;
};


