/*
# mrcImageLocalMaximumValuesFind : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageLocalMaximumValuesFind
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"

typedef struct lmrcImageLocalMaximumValuesFindInfo {
	double threshold; 
	int size;
} lmrcImageLocalMaximumValuesFindInfo;

typedef enum lmrcImageLocalMaximumValuesFindMode {
	a=0,
	b=1
} lmrcImageLocalMaximumValuesFindMode;

extern void lmrcImageLocalMaximumValuesFind(mrcImage* out, mrcImage* in, lmrcImageLocalMaximumValuesFindInfo* linfo, int mode); 

int
main(int argc, char* argv[]) 
{
	mrcImageLocalMaximumValuesFindInfo info;
	lmrcImageLocalMaximumValuesFindInfo linfo;
	mrcImage in;
	mrcImage out;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");

	linfo.size = info.Size;
	linfo.threshold = info.Threshold;

	mrcFileRead(&in, info.In, "in main", 0);

	lmrcImageLocalMaximumValuesFind(&out, &in, &linfo, info.mode); 

	mrcFileWrite(&out, info.Out, "in main", 0);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}


void 
lmrcImageLocalMaximumValuesFind(mrcImage* out, mrcImage* in, lmrcImageLocalMaximumValuesFindInfo* linfo, int mode) 
{
	int x, y, z;
	int X, Y, Z;
	double data, d, dst, rr;
	int flag;

	out->Header = in->Header;
	mrcInit(out, NULL);

	for(x=0; x<in->HeaderN.x; x++) {
	for(y=0; y<in->HeaderN.y; y++) {
	for(z=0; z<in->HeaderN.z; z++) {
		mrcPixelDataSet(out, x, y, z, 1, mrcPixelRePart);	
	}
	}
	}

	for(x=0; x<in->HeaderN.x; x++) {
	for(y=0; y<in->HeaderN.y; y++) {
	for(z=0; z<in->HeaderN.z; z++) {
		mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);	
		if(linfo->threshold<data) {
			flag = 1;
			for(X=x-linfo->size/2; X<=x+linfo->size/2 && flag==1; X++) {		
			for(Y=y-linfo->size/2; Y<=y+linfo->size/2 && flag==1; Y++) {		
			for(Z=z-linfo->size/2; Z<=z+linfo->size/2 && flag==1; Z++) {		
				rr = SQR(X-x)+SQR(Y-y)+SQR(Z-z);
				if(0 < rr && rr <= SQR(linfo->size)) {
					mrcPixelDataGet(in, X, Y, Z, &d, mrcPixelRePart, mrcPixelHowNearest);
					if(data<d) {
						flag = 0;
					}
				}
			}
			}
			}
			if(flag==1) {
				mrcPixelDataSet(out, x, y, z, data, mrcPixelRePart);
			} else {
				mrcPixelDataSet(out, x, y, z, 0, mrcPixelRePart);
			}
		} else {
			mrcPixelDataSet(out, x, y, z, 0, mrcPixelRePart);
		}
	}
	}
	}
}
