/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% dmFileRead ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : dmFileRead 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%dmFileRead ver%I%; Date:%D% %Z%";
#define DEBUG
#include "genUtil.h"
#include "Memory.h"
#include "../inc/dmFile.h"

void
dmFileRead(FILE* fpt, dmFile* dm, char* message, int mode)
{
	fseek(fpt, 0L, SEEK_SET);
	fread(&(dm->version), sizeof(dmFileInteger4), 1, fpt);
#ifdef II
	memoryByteSwap(&(dm->version), sizeof(dmFileInteger4), 1);
#endif
	DEBUGPRINT1("version: %d\n", dm->version);

	fseek(fpt, -8L, SEEK_END);
	fread(&(dm->Tail), sizeof(dmFileInteger8), 1, fpt);
	if(dm->Tail!=0 && 3<=dm->version) {
		fprintf(stderr, "This file is not dm3/dm4: version %d \n", dm->version);
		exit(EXIT_FAILURE);
	}

	switch(dm->version) {
		case 3: {
			// Header
			fseek(fpt, 0L, SEEK_SET);
			if(12!=sizeof(dm->Header4)) {
				fprintf(stderr, "Size is strange: %lu expected 12\n", sizeof(dm->Header4));
				fread(&(dm->Header3.version), sizeof(dm->Header3.version), 1, fpt);
				fread(&(dm->Header3.rootLength), sizeof(dm->Header3.rootLength), 1, fpt);
				fread(&(dm->Header3.byteOrder), sizeof(dm->Header3.byteOrder), 1, fpt);
			} else {
				DEBUGPRINT1("Header3 Size: %lu expect 12\n", sizeof(dm->Header4));
				fread(&(dm->Header3), sizeof(dm->Header3), 1, fpt);
			}
#ifdef II
			memoryByteSwap(&(dm->Header3.version), sizeof(dmFileInteger4), 1);
			memoryByteSwap(&(dm->Header3.rootLength), sizeof(dmFileInteger4), 1);
			memoryByteSwap(&(dm->Header3.byteOrder), sizeof(dmFileInteger4), 1);
#endif
			DEBUGPRINT1("version:    %d\n", dm->Header3.version);
			DEBUGPRINT1("RootLength: %d\n", dm->Header3.rootLength);
			DEBUGPRINT1("ByteOrder:  %d\n", dm->Header3.byteOrder);

			// Root Tag
			fread(&(dm->RootTag3.sortf), sizeof(dmFileInteger1), 1, fpt);
			fread(&(dm->RootTag3.closef), sizeof(dmFileInteger1), 1, fpt);
			fread(&(dm->RootTag3.numberOfTags), sizeof(dmFileInteger4), 1, fpt);
#ifdef II
			memoryByteSwap(&(dm->RootTag3.numberOfTags), sizeof(dmFileInteger4), 1);
#endif
			DEBUGPRINT1("sortf:    %d\n", dm->RootTag3.sortf);
			DEBUGPRINT1("closef:   %d\n", dm->RootTag3.closef);
			DEBUGPRINT1("numberOfTags:   %d\n", dm->RootTag3.numberOfTags);
			break;
		}
		case 4: {
			// Header
			fseek(fpt, 0L, SEEK_SET);
			if(16!=sizeof(dm->Header4)) {
				fprintf(stderr, "Size is strange: %lu expected 16\n", sizeof(dm->Header4));
				fread(&(dm->Header4.version), sizeof(dm->Header4.version), 1, fpt);
				fread(&(dm->Header4.rootLength), sizeof(dm->Header4.rootLength), 1, fpt);
				fread(&(dm->Header4.byteOrder), sizeof(dm->Header4.byteOrder), 1, fpt);
			} else {
				DEBUGPRINT1("Header4 Size: %lu expect 16\n", sizeof(dm->Header4));
				fread(&(dm->Header4), sizeof(dm->Header4), 1, fpt);
			}
#ifdef II
			memoryByteSwap(&(dm->Header4.version), sizeof(dmFileInteger4), 1);
			memoryByteSwap(&(dm->Header4.rootLength), sizeof(dmFileInteger8), 1);
			memoryByteSwap(&(dm->Header4.byteOrder), sizeof(dmFileInteger4), 1);
#endif
			DEBUGPRINT1("version:    %d\n", dm->Header4.version);
			DEBUGPRINT1("RootLength: %lld\n", dm->Header4.rootLength);
			DEBUGPRINT1("ByteOrder:  %d\n", dm->Header4.byteOrder);

			// Root Tag
			fread(&(dm->RootTag4.sortf), sizeof(dmFileInteger1), 1, fpt);
			fread(&(dm->RootTag4.closef), sizeof(dmFileInteger1), 1, fpt);
			fread(&(dm->RootTag4.numberOfTags), sizeof(dmFileInteger8), 1, fpt);
#ifdef II
			memoryByteSwap(&(dm->RootTag4.numberOfTags), sizeof(dmFileInteger8), 1);
#endif
			DEBUGPRINT1("sortf:    %d\n", dm->RootTag4.sortf);
			DEBUGPRINT1("closef:   %d\n", dm->RootTag4.closef);
			DEBUGPRINT1("numberOfTags:   %lld\n", dm->RootTag4.numberOfTags);
			break;
		}
		default: {
			fprintf(stderr, "Not supported version: %d\n", dm->version);
			break;
		}
	}
}
