/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageMorphology ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageMorphology 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrcImageMorphology ver%I%; Date:%D% %Z%";

#include <stdio.h>
#include "./lmrcImageMorphology.h"

void
lmrcImageMorphologyStructuringElementSet(lmrcImageMorphologyInfo* linfo, int mode)
{
	switch(linfo->mode) {
		case 0: {
			lmrcImageMorphologyStructuringElement2DCross(&linfo->SE, mode);
			break;
		}
		case 1: {
			lmrcImageMorphologyStructuringElement2DSquare(&linfo->SE, mode);
			break;
		}
		case 2: {
			lmrcImageMorphologyStructuringElement2DOpenDisk(&linfo->SE, linfo->radius, linfo->n, mode);
			break;
		}
		case 3: {
			lmrcImageMorphologyStructuringElement3DCross(&linfo->SE, mode);
			break;
		}
		case 4: {
			lmrcImageMorphologyStructuringElement3DCubic(&linfo->SE, mode);
			break;
		}
		case 5: {
			lmrcImageMorphologyStructuringElement3DOpenSphere(&linfo->SE, linfo->radius, linfo->n, mode);
			break;
		}
		default: {
			fprintf(stderr, "Not supported mode in lmrcImageMorphologyStructuringElementSet: %d", linfo->mode);
			exit(EXIT_FAILURE);
		}
	}
}
	

void
lmrcImageMorphologyStructuringElementSetInfoPrint(FILE* fpt)
{
	fprintf(fpt, "0: 2D Cross3x3:  4-neighbour\n");
	fprintf(fpt, "1: 2D Square3x3: 8-neighbour\n");
	fprintf(fpt, "2: 2D Open Disk , need (radius, n)\n");
	fprintf(fpt, "3: 3D Cross3x3x3:   6-neighbour\n");
	fprintf(fpt, "4: 3D Cubic3x3x3: 26-neighbour\n");
	fprintf(fpt, "5: 3D Open Disk , need (radius, n)\n");

	fprintf(fpt, "-----\n");
	fprintf(fpt, "Dilation: Max for image : Or  for binary image \n");
	fprintf(fpt, "Erosion:  Min for image : And for binary image \n");
}


void
lmrcImageMorphologyStructuringElement2DCross(mrcImage* out, int mode)
{
	mrcDefaultHeaderValueSet(out);
	out->HeaderN.x = 3;
	out->HeaderN.y = 3;
	out->HeaderN.z = 1;
	out->HeaderStartN.x = -1;
	out->HeaderStartN.y = -1;
	out->HeaderStartN.z = 0;
	out->HeaderMode = mrcCharImage;
	mrcInit(out, NULL);
	mrcPixelDataSet(out, 0, 2, 0, 0, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 2, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 2, 0, 0, mrcPixelRePart); 
	mrcPixelDataSet(out, 0, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 0, 0, 0, 0, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 0, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 0, 0, 0, mrcPixelRePart); 
}

void
lmrcImageMorphologyStructuringElement2DSquare(mrcImage* out, int mode)
{
	mrcDefaultHeaderValueSet(out);
	out->HeaderN.x = 3;
	out->HeaderN.y = 3;
	out->HeaderN.z = 1;
	out->HeaderStartN.x = -1;
	out->HeaderStartN.y = -1;
	out->HeaderStartN.z = 0;
	out->HeaderMode = mrcCharImage;
	mrcInit(out, NULL);
	mrcPixelDataSet(out, 0, 2, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 2, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 2, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 0, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 1, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 0, 0, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 0, 0, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 2, 0, 0, 1, mrcPixelRePart); 
}


void
lmrcImageMorphologyStructuringElementOpenSphere(mrcImage* out, int r, int n, int mode)
{
	int x, y, z;
	int rx, ry, rz;
	double rr, r2;
	double data;

	mrcDefaultHeaderValueSet(out);
	out->HeaderN.x = n;
	out->HeaderN.y = n;
	out->HeaderN.z = 1;
	out->HeaderStartN.x = -n/2;
	out->HeaderStartN.y = -n/2;
	out->HeaderStartN.z = 0;
	out->HeaderMode = mrcCharImage;
	mrcInit(out, NULL);

	r2 = r*r;
	for(z=0; z<out->HeaderN.z; z++) {
		rz = z + out->HeaderStartN.z; 
	for(y=0; y<out->HeaderN.y; y++) {
		ry = y + out->HeaderStartN.y; 
	for(x=0; x<out->HeaderN.x; x++) {
		rx = x + out->HeaderStartN.x; 
		rr = rx*rx + ry*ry+ rz*rz; 	
		if(rr <= r2) {
			mrcPixelDataSet(out, x, y, z, 1, mrcPixelRePart);	
		} else {
			mrcPixelDataSet(out, x, y, z, 0, mrcPixelRePart);	
		}
	}
	}
	}
}

void
lmrcImageMorphologyStructuringElement2DOpenDisk(mrcImage* out, int r, int n, int mode)
{
	lmrcImageMorphologyStructuringElementOpenSphere(out, r, n, mode);
}

void
lmrcImageMorphologyStructuringElement3DCross(mrcImage* out, int mode)
{
	float x, y, z;
	mrcDefaultHeaderValueSet(out);
	out->HeaderN.x = 3;
	out->HeaderN.y = 3;
	out->HeaderN.z = 1;
	out->HeaderStartN.x = -1;
	out->HeaderStartN.y = -1;
	out->HeaderStartN.z = 0;
	out->HeaderMode = mrcCharImage;
	mrcInit(out, NULL);


	for(z=0; z<3; z++) {
	for(y=0; y<3; y++) {
	for(x=0; x<3; x++) {
		mrcPixelDataSet(out, x, y, z, 0, mrcPixelRePart); 
	}
	}
	}
	mrcPixelDataSet(out, 1, 1, 1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1-1, 1, 1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1+1, 1, 1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1-1, 1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1+1, 1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1, 1-1, 1, mrcPixelRePart); 
	mrcPixelDataSet(out, 1, 1, 1+1, 1, mrcPixelRePart); 
}

void
lmrcImageMorphologyStructuringElement3DCubic(mrcImage* out, int mode)
{
	float x, y, z;

	mrcDefaultHeaderValueSet(out);
	out->HeaderN.x = 3;
	out->HeaderN.y = 3;
	out->HeaderN.z = 1;
	out->HeaderStartN.x = -1;
	out->HeaderStartN.y = -1;
	out->HeaderStartN.z = 0;
	out->HeaderMode = mrcCharImage;
	mrcInit(out, NULL);
	for(z=0; z<3; z++) {
	for(y=0; y<3; y++) {
	for(x=0; x<3; x++) {
		mrcPixelDataSet(out, x, y, z, 1, mrcPixelRePart); 
	}
	}
	}
}


void
lmrcImageMorphologyStructuringElement3DOpenSphere(mrcImage* out, int r, int n, int mode)
{
	lmrcImageMorphologyStructuringElementOpenSphere(out, r, n, mode);
}
