#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile:  mrcImage\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile: Parameters\n");
    fprintf(stderr, "    [-D[efocus]          Defocus             (0.0       )] :Optional  :InitialDefocus[A]\n");
    fprintf(stderr, "    [-Cs                 Cs                  (1.7       )] :Optional  :InitialCs[mm]\n");
    fprintf(stderr, "    [-Cc                 Cc                  (1.2       )] :Optional  :InitialCs[mm]\n");
    fprintf(stderr, "    [-dE                 dE                  (0.2       )] :Optional  :InitialCs[mm]\n");
    fprintf(stderr, "    [-Ac[cerratedVoltage]Ac                  (200       )] :Optional  :Ac[kV]\n");
    fprintf(stderr, "    [-CutLow             CutLow              (0.05      )] :Optional  :CutOffLowFrequncy[/A]\n");
    fprintf(stderr, "    [-CutHigh            CutHigh             (0.5       )] :Optional  :CutOffHighFrequncy[/A]\n");
    fprintf(stderr, "    [-I0                 I0                  (1.0       )] :Optional  :I0\n");
    fprintf(stderr, "    [-ratio              ratioOfAmpToPhase   (0.1       )] :Optional  :ratioOfAmpToPhase\n");
    fprintf(stderr, "    [-Ai                 Ai                  (0.03      )] :Optional  :IlluminationAngle[mrad]\n");
    fprintf(stderr, "    [-BofMTF             BofMTF              (15.0      )] :Optional  :B of MTF [A]\n");
    fprintf(stderr, "    [-BofV[ibration]     BofVibration        (3.0       )] :Optional  :B of Vibration [A]\n");
    fprintf(stderr, "    [-Mag[nification]    Magnification       (1.0       )] :Optional  :Magnification\n");
    fprintf(stderr, "    [-[White]Noise       WhiteNoise          (0.0       )] :Optional  :Signal/Noise Ratio\n");
    fprintf(stderr, "    [-[White]Noise2      WhiteNoise2         (0.0       )] :Optional  :Signal/Noise Ratio\n");
    fprintf(stderr, "    [-MolcEnv            MolcEnv             (0.0       )] :Optional  :Gaussian: Molcular Envelop [A]\n");
    fprintf(stderr, "    [-MolcEnv2           MolcEnvTable        (NULL      )] :Optional  :Table: Molcular Envelop\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-min                min                 (-10       )] :Optional  :min of coefficient area\n");
    fprintf(stderr, "    [-max                max                 (10        )] :Optional  :max of coefficient area\n");
    fprintf(stderr, "    [-s[tep]             step                (0.01      )] :Optional  :step of coefficient\n");
    fprintf(stderr, "    [-d[egree]           degree              (6         )] :Optional  :agree of function\n");
    fprintf(stderr, "    [-S[ection]          section             (4         )] :Optional  :section number of fft\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
