#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            inFile              (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           outFile             (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-r[esolution]       Resolution          (2.5       )] :Optional  :Resolution[A]\n");
    fprintf(stderr, "    [-t[ime]             time                (1.0       )] :Optional  :x OptimalTime\n");
    fprintf(stderr, "    [-d[irnum]           dirnum              (0         )] :Optional  :tiffDirectoryNumber\n");
    fprintf(stderr, "    [-I[nverse]          ] :Optional  :Black<->White\n");
    fprintf(stderr, "    [-Signed             ] :Optional  :Original image is Signed or Not: Default unsigned\n");
    fprintf(stderr, "    [-Offset             Offset              (0.0       )] :Optional  :OffsetValue\n");
    fprintf(stderr, "    [-Max                Max                 (16        )] :Optional  :MaxValue:2^Max\n");
    fprintf(stderr, "    [-Min                Min                 (1         )] :Optional  :MinValue:2^Min: without 0\n");
    fprintf(stderr, "    [-realMin            realMin             (0.0       )] :Optional  :Real MinValue\n");
    fprintf(stderr, "    [-realMax            realMax             (0.0       )] :Optional  :Real MaxValue\n");
    fprintf(stderr, "    [-realMaxBit         realMaxBit          (14        )] :Optional  :Real MaxValue Bit\n");
    fprintf(stderr, "    [-sin                sinFile             (NULL      )] :Optional  :sin file from Zeiss\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-S[hrink]           Shrink              (8         )] :Optional  :ShrinkMode\n");
    fprintf(stderr, "    [-M[ode]             Mode                (0         )] :Optional  :Mode: mrcMode: Def: if -m 0, -M 0. if -m 1 -M 2\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode: 0 (Direct), 1(Log10(65535/data))\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
