#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  ] :Essential :InputDataFile(mrcImage)\n");
    fprintf(stderr, "    [-p[dbFile]          InPDB               ] :Essential :InputDataFile(pdbFile)\n");
    fprintf(stderr, "    [-o[utput]           Out                 ] :Essential :OutputDataFile(pdbFile)\n");
    fprintf(stderr, "    [-H[igh]             HighLevel           ] :Optional  :HighLevel\n");
    fprintf(stderr, "    [-L[ow]              LowLevel            ] :Optional  :LowLevel\n");
    fprintf(stderr, "    [-c[onfig]           configFile          ] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                ] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
