#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-i[nput]S[ource]fileInS                 (NULL      )] :Essential :InputSourceFile\n");
    fprintf(stderr, "    [-o[utput]E[xtract]  OutE                (NULL      )] :Essential :OutputFileForExtraction\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output Log File\n");
    fprintf(stderr, "    [-o[utput]F[inal]    OutF                (stdout    )] :Optional  :OutputFinalFile\n");
    fprintf(stderr, "    [-r[oi]ROI           blx                 (0.0       )bly                 (0.0       )brx                 (0.0       )bry                 (0.0       )trx                 (0.0       )try                 (0.0       )tlx                 (0.0       )tly                 (0.0       )] :Optional  :Rectangle ROI \n");
    fprintf(stderr, "    [-r[oi]Unbent        roiLine             (0.0       )... ] :Variable  :\n");
    fprintf(stderr, "    [-x                  x                   (120       )] :Optional  :x range for ROI or Unbent\n");
    fprintf(stderr, "    [-d[elta]dYmax       ddYmax              (0.9       )] :Optional  :delta dY max\n");
    fprintf(stderr, "    [-d[elta]dYmin       ddYmin              (0.2       )] :Optional  :delta dY mim\n");
    fprintf(stderr, "    [-T[ransepose]       T                   (0         )] :Optional  :corresponding to mrcImageTransepose mode\n");
    fprintf(stderr, "    [-maxd[elta]Y        maxdY               (12        )] :Optional  :Maximum number of layer line\n");
    fprintf(stderr, "    [-H[eight] R[ange]   HeightRange         (0         )] :Optional  :Height Range [Pixel]\n");
    fprintf(stderr, "    [-RMaxX              RMaxX               (0.05      )] :Optional  :RMaxX [1/A] (supported mode 1)\n");
    fprintf(stderr, "    [-mag                mag                 (1.1       )] :Optional  :magnification ratio\n");
    fprintf(stderr, "    [-truePitch          truePitch           (430       )] :Optional  :True Pitch [A]\n");
    fprintf(stderr, "    [-PixelSize          PixelSize           (5         )] :Optional  :Pixel Size [A]\n");
    fprintf(stderr, "    [-finaly             finaly              (0         )] :Optional  :final y [pixel] for extraction\n");
    fprintf(stderr, "    [-Ignore             Ignore              (0         )] :Optional  :Ignore the final y \n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
