#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-r[ed]              rIn                 (NULL      )] :Optional  :Red:InputDataFile\n");
    fprintf(stderr, "    [-g[reen]            gIn                 (NULL      )] :Optional  :Green:InputDataFile\n");
    fprintf(stderr, "    [-b[lue]             bIn                 (NULL      )] :Optional  :Blue:InputDataFile\n");
    fprintf(stderr, "    [-rH[ight]           rHigh               (1         )] :Optional  :Red:HighThres\n");
    fprintf(stderr, "    [-rL[ow]             rLow                (0         )] :Optional  :Red:LowThres\n");
    fprintf(stderr, "    [-gH[ight]           gHigh               (1         )] :Optional  :Green:HighThres\n");
    fprintf(stderr, "    [-gL[ow]             gLow                (0         )] :Optional  :Green:LowThres\n");
    fprintf(stderr, "    [-bH[ibht]           bHigh               (1         )] :Optional  :Blue:HibhThres\n");
    fprintf(stderr, "    [-bL[ow]             bLow                (0         )] :Optional  :BLue:LowThres\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :gif:OutputDataFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
