#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[output]          Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-r[esolution]       r                   (0.0       )] :Optional  :Pixel size\n");
    fprintf(stderr, "    [-x[length]          Lx                  (0.0       )] :Optional  :Pixel size along x axis(A).Default:No change\n");
    fprintf(stderr, "    [-y[length]          Ly                  (0.0       )] :Optional  :Pixel size along y axis(A).Default:No change\n");
    fprintf(stderr, "    [-z[length]          Lz                  (0.0       )] :Optional  :Pixel size along z axis(A).Default:No change\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
