#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :InputDataFile\n");
    fprintf(stderr, "    [-r[esolution]       Resolution          (1.666666  )] :Optional  :Size of pixel[A].\n");
    fprintf(stderr, "    [-Nx[Number of x]    Nx                  (0         )] :Essential :Number of x\n");
    fprintf(stderr, "    [-Ny[Number of y]    Ny                  (0         )] :Essential :Number of y\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
