#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-ix[initial x]      ix                  (NULL      )] :Optional  :Initial x(pixel)\n");
    fprintf(stderr, "    [-ia[initial alpha]  ia                  (0         )] :Optional  :Initial alpha(degree)\n");
    fprintf(stderr, "    [-r[eference]        Ref                 (NULL      )] :Optional  :ReferenceFile\n");
    fprintf(stderr, "    [-dy[deltay]         Dy                  (10        )] :Optional  :Deltay\n");
    fprintf(stderr, "    [-xrange             xrange              (3         )] :Optional  :x range to search (pixel)\n");
    fprintf(stderr, "    [-arange             arange              (2         )] :Optional  :alpha range to search (degree)\n");
    fprintf(stderr, "    [-v[alue]            Value               (1         )] :Optional  :Value of Peak Pixel :for mode2\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-M[ode2]            mode2               (0         )] :Optional  :Mode2\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
