#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nputFileLiest]   In                  (NULL      )] :Essential :InputDataFileList\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFileHeader\n");
    fprintf(stderr, "    [-e[xtension]        extension           (NULL      )] :Essential :OutputDataFileExtension\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    fprintf(stderr, "    [-i[ncrease]r[ate]   ir                  (1         )] :Optional  :IncreaseRate\n");
    fprintf(stderr, "    [-h[ybridization]p[oint]n[umber]hpn                 (1         )] :Optional  :HybridizationPointNumber\n");
    fprintf(stderr, "    [-m[ode]s[election]  ms                  (0         )] :Optional  :ModeOfSelection\n");
    fprintf(stderr, "    [-i[nitial]r[andom]d[ata]ird                 (0         )] :Optional  :InitialRandomData\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
