/*
# CommonLineRankCalc_k : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : CommonLineRankCalc_k
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "File.h"
#include "Memory.h"
#include "String.h"

/*
Example:
typedef struct lCommonLineRankCalc_kInfo {
	float a;
	int   b;
} lCommonLineRankCalc_kInfo;

typedef enum lCommonLineRankCalc_kMode {
	a=0,
	b=1
} lCommonLineRankCalc_kMode;
*/
int __calcRank(mrcImage* in, double clvalue, int mode);
void __rankPrint(int* r5, int* r500, FILE* out);
int
main(int argc, char* argv[]) 
{
	CommonLineRankCalc_kInfo info;
	char s[1024],ss[128];
	double cldata, dclposx, dclposy, cldata2;
	int clposx, clposy;
	int y, dy, rank;
	int rank5[201];
	int rank500[130];
	mrcImage in;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	
	for(y=0;y<201;y++) rank5[y]=0;
	for(y=0;y<130;y++) rank500[y]=0;
	fseek(info.fptIn, 0L, SEEK_SET);
	fseek(info.fptInMap, 0L, SEEK_SET);
	stringGetFromFile(s,"",info.fptInMap,stdout,1);
	mrcFileRead(&in,s,"in main",0);
	y = in.HeaderN.x;
	dy = 360/y;
	fseek(info.fptInMap, 0L, SEEK_SET);
	//fprintf(stderr,"in main before while-loop\n");
	while(NULL!=stringGetFromFile(s,"",info.fptIn,stdout,1)){
		stringGetFromFile(ss,"",info.fptInMap,stdout,1);
		dclposx = (double)stringGetNthRealData(s, 3, " ,\t");
		dclposy = (double)stringGetNthRealData(s, 4, " ,\t");
		dclposx *= dy; dclposy *= dy;
		clposx = (int)dclposx;  clposx += (int)((dclposx - (double)clposx)*2.0);
		clposy = (int)dclposy;  clposy += (int)((dclposy - (double)clposy)*2.0);
		//fprintf(stderr,"%f\t%f\t%d\t%d\n",dclposx,dclposy,clposx,clposy);
		mrcFileRead(&in,ss,"in main",0);
		//fprintf(stderr,"in main after mrcRead\n");
		mrcPixelDataGet(&in,clposx,clposy,0,&cldata, mrcPixelRePart, mrcPixelHowNearest);
		mrcPixelDataGet(&in,clposx+y/2,clposy+y/2,0,&cldata2, mrcPixelRePart, mrcPixelHowNearest);
		cldata = pow(cldata*cldata2,0.5);
		//fprintf(stderr,"in main before __calcRank\n");
		rank = __calcRank(&in, cldata, 0);
		//fprintf(stderr,"in main after __calcRank\n");
		
		rank500[rank/500]++;
		if(rank < 1000) rank5[rank/5]++;
		//fprintf(stderr,"in main after __calcRank\n");
	}
	//fprintf(stderr,"in main before rankprint\n");
	__rankPrint(rank5,rank500,stdout);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}

int __calcRank(mrcImage* in, double clvalue, int mode)
{
	int i,j,y,hy,count=0;
	double data,data2;
	y = in->HeaderN.x;
	hy = y/2;
	for(i=0;i<y;i++){ for(j=0;j<hy;j++){
		mrcPixelDataGet(in,i,j,0,&data, mrcPixelRePart, mrcPixelHowNearest);
		mrcPixelDataGet(in,i+hy,j+hy,0,&data2, mrcPixelRePart, mrcPixelHowNearest);
		data = pow(data*data2,0.5);
		if(data >= clvalue) count++;
	}}
	count--;
	return count;
}

void __rankPrint(int* r5, int* r500, FILE* out)
{
	int i,j,total;
	fprintf(out,"rank 0-1000 d=5\n");
	total=0;
	for(i=0;i<201;i++){
		total += r5[i];
		fprintf(out,"%d-%d\t%d\t%d\n",i*5,(i*5)+4,total,r5[i]);
	}
	fprintf(out,"\nrank 0-64800 d=500\n");
	total=0;
	for(i=0;i<130;i++){
		total += r500[i];
		fprintf(out,"%d-%d\t%d\t%d\n",i*500,(i*500)+499,total,r500[i]);
	}
}

