'use strict';

var _ = require('lodash');

var constructor = require('./upload.constructor');
var singleton   = require('pragma-singleton');

var constructorTable = {};

exports.create = function (req, res) {
    var wsName = req.params.workspace;
    if (!constructorTable[wsName]) {
        constructorTable[wsName] = singleton(constructor.singleton);
    }
    var workspace = new constructorTable[wsName]();
    workspace.create(req, res);
};


exports.post = function (req, res) {
    var wsName = req.params.workspace;
    if (!constructorTable[wsName]) {
        constructorTable[wsName] = singleton(constructor.singleton);
    };
    var workspace = new constructorTable[wsName]();
    workspace.post(req, res);
};

exports.read = function (req, res) {
    var wsName = req.params.workspace;
    if (!constructorTable[wsName]) {
        constructorTable[wsName] = singleton(constructor.singleton);
    };
    var workspace = new constructorTable[wsName]();
    res.send(workspace.read());
}

exports.update = function (req, res) {
    var wsName = req.params.workspace;
    if (!constructorTable[wsName]) {
        constructorTable[wsName] = singleton(constructor.singleton);
    };
    var workspace = new constructorTable[wsName]();
    workspace.update(req, res);
};

exports.delete = function(req, res) {
    var wsName = req.params.workspace;
    if (!constructorTable[wsName]) {
        constructorTable[wsName] = singleton(constructor.singleton);
    };
    var workspace = new constructorTable[wsName]();
    workspace.delete(req, res);
};
