##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Visual appearance editor
#===========================================

proc dialog-prefs:CreateDialog {parent} {
#--------------------------------------------
    set this [dialog:CreateTabDialog $parent "dialog-prefs" Apply Cancel Ok]
    if {![winfo exists $this]} {
        return ""
    }

    wm geometry $this 480x280+293+198
    wm minsize $this 480 280
    wm title $this "Visual appearance preferences"

    dialog-prefs:CreateFontsPage $this
    dialog-prefs:CreateColorsPage $this
    dialog-prefs:CreatePositionsPage $this
    dialog-prefs:CreatePredefinedPage $this
    dialog:ActivateTabPage $this Fonts
    dialog:CenterDialog $this
    return $this
}

proc dialog-prefs:CreateFontsPage {this} {
#--------------------------------------------
    set page [dialog:CreateTabPage $this Fonts]

    frame  $page.f1 -borderwidth 1 -height 30 -relief flat -width 30 
    button $page.f1.menubtn -padx 9 -pady 3 -relief groove -text menu... -width 10 \
        -command "main:DlgDispatch OnChooseFont $this $page.f1.menuent"
    entry  $page.f1.menuent -relief ridge
    frame  $page.f2 -borderwidth 1 -height 30 -relief flat -width 30 
    button $page.f2.toolbtn -padx 9 -pady 3 -relief groove -text tooltip... -width 10 \
        -command "main:DlgDispatch OnChooseFont $this $page.f2.toolent"
    entry  $page.f2.toolent -relief ridge
    frame  $page.f3 -borderwidth 1 -height 30 -relief flat -width 30 
    button $page.f3.status -padx 9 -pady 3 -relief groove -text status... -width 10 \
        -command "main:DlgDispatch OnChooseFont $this $page.f3.statusent"
    entry  $page.f3.statusent  -relief ridge
    frame  $page.f4 -borderwidth 1 -height 30 -relief flat -width 30 
    button $page.f4.caption -padx 9 -pady 3 -relief groove -text caption... -width 10 \
        -command "main:DlgDispatch OnChooseFont $this $page.f4.captionent"
    entry  $page.f4.captionent  -relief ridge
    frame  $page.f5 -borderwidth 1 -height 30 -relief flat -width 30 
    button $page.f5.def -padx 9 -pady 3 -relief groove -text default... -width 10 \
        -command "main:DlgDispatch OnChooseFont $this $page.f5.defent"
    entry  $page.f5.defent  -relief ridge

    pack $page.f1 -anchor center -expand 1 -fill x -side top 
    pack $page.f1.menubtn -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f1.menuent  -anchor center -expand 1 -fill x -side right 
    pack $page.f2  -anchor center -expand 1 -fill x -side top 
    pack $page.f2.toolbtn  -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f2.toolent -anchor center -expand 1 -fill x -side right 
    pack $page.f3 -anchor center -expand 1 -fill x -side top 
    pack $page.f3.status -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f3.statusent -anchor center -expand 1 -fill x -side right 
    pack $page.f4  -anchor center -expand 1 -fill x -side top 
    pack $page.f4.caption -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f4.captionent -anchor center -expand 1 -fill x -side right
    pack $page.f5  -anchor center -expand 1 -fill x -side top 
    pack $page.f5.def -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f5.defent -anchor center -expand 1 -fill x -side right
}

proc dialog-prefs:CreateColorsPage {this} {
#--------------------------------------------
    set page [dialog:CreateTabPage $this Colors]

    frame  $page.f1 -borderwidth 1 -height 1 -relief flat -width 30 
    listbox $page.f1.list -height 1 -relief sunken  -borderwidth 1 -yscrollcommand "$page.f1.yscroll set"
    scrollbar $page.f1.yscroll -orient vertical -relief ridge -command "$page.f1.list yview"
    bind $page.f1.list <Button-1> {main:DlgDispatch OnSelectColorItem "" [%W index @%x,%y]}

    frame  $page.f2 -borderwidth 1 -height 20 -relief flat -width 30 
    frame  $page.f2.sample -borderwidth 2 -height 10 -relief ridge -width 30 
    frame  $page.f2.red -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f2.red.l -anchor w -relief flat -width 5 -text {Red}
    scale  $page.f2.red.s -orient horiz -from 0.0 -to 16.0 -showvalue 0 \
        -command "main:DlgDispatch OnChooseColor $this"
    frame  $page.f2.green -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f2.green.l -anchor w -relief flat -width 5 -text {Green}
    scale  $page.f2.green.s -orient horiz -from 0.0 -to 16.0 -showvalue 0 \
        -command "main:DlgDispatch OnChooseColor $this"
    frame  $page.f2.blue -borderwidth 1 -height 1 -relief flat -width 30 
    label  $page.f2.blue.l -anchor w -relief flat -width 5 -text {Blue}
    scale  $page.f2.blue.s -orient horiz -from 0.0 -to 16.0 -showvalue 0 \
        -command "main:DlgDispatch OnChooseColor $this"

    pack $page.f1 -anchor center -expand 1 -fill both -side left
    pack $page.f1.list -expand 1 -fill both -side left
    pack $page.f1.yscroll -fill y -side right

    pack $page.f2 -anchor center -expand 1 -fill both -side right
    pack $page.f2.sample -anchor center -expand 1 -fill both -padx 15 -pady 5 -side top 
    pack $page.f2.red -anchor center -expand 1 -fill x -side top 
    pack $page.f2.red.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f2.red.s -anchor center -expand 1 -fill x -side right 
    pack $page.f2.green -anchor center -expand 1 -fill x -side top 
    pack $page.f2.green.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f2.green.s -anchor center -expand 1 -fill x -side right 
    pack $page.f2.blue -anchor center -expand 1 -fill x -side top 
    pack $page.f2.blue.l -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f2.blue.s -anchor center -expand 1 -fill x -side right 
}

proc dialog-prefs:CreatePositionsPage {this} {
#--------------------------------------------
    global dlgdata
    set page [dialog:CreateTabPage $this Positions]
    set id [main:GetWindowId $this]

    frame  $page.f1 -borderwidth 1 -height 30 -relief groove -width 30 
    label $page.f1.menubar -padx 9 -pady 3 -relief flat -text "Menubar:" -width 10
    radiobutton  $page.f1.pos0 -anchor w -relief flat -width 10 -text {Top} -variable dlgdata($id,position,menubar) -value "0"
    radiobutton  $page.f1.pos1 -anchor w -relief flat -width 10 -text {Left} -variable dlgdata($id,position,menubar) -value "1"
    radiobutton  $page.f1.pos2 -anchor w -relief flat -width 10 -text {Bottom} -variable dlgdata($id,position,menubar) -value "2"
    radiobutton  $page.f1.pos3 -anchor w -relief flat -width 10 -text {Right} -variable dlgdata($id,position,menubar) -value "3"
    frame  $page.f2 -borderwidth 1 -height 30 -relief groove -width 30 
    label $page.f2.toolbar -padx 9 -pady 3 -relief flat -text "Toolbar:" -width 10
    radiobutton  $page.f2.pos0 -anchor w -relief flat -width 10 -text {Top} -variable dlgdata($id,position,toolbar) -value "0"
    radiobutton  $page.f2.pos1 -anchor w -relief flat -width 10 -text {Left} -variable dlgdata($id,position,toolbar) -value "1"
    radiobutton  $page.f2.pos2 -anchor w -relief flat -width 10 -text {Bottom} -variable dlgdata($id,position,toolbar) -value "2"
    radiobutton  $page.f2.pos3 -anchor w -relief flat -width 10 -text {Right} -variable dlgdata($id,position,toolbar) -value "3"
    frame  $page.f3 -borderwidth 1 -height 30 -relief groove -width 30 
    label $page.f3.statusbar -padx 9 -pady 3 -relief flat -text "Statusbar:" -width 10
    radiobutton  $page.f3.pos0 -anchor w -relief flat -width 10 -text {Top} -variable dlgdata($id,position,statusbar) -value "0"
    radiobutton  $page.f3.pos2 -anchor w -relief flat -width 10 -text {Bottom} -variable dlgdata($id,position,statusbar) -value "2"
    frame  $page.f4 -borderwidth 1 -height 30 -relief groove -width 30 
    label $page.f4.orient -padx 9 -pady 3 -relief flat -text "Orientation:" -width 10
    checkbutton  $page.f4.lr -anchor w -relief flat -width 10 -text {Left-to-Right} -variable dlgdata($id,position,leftright)
    checkbutton  $page.f4.tb -anchor w -relief flat -width 10 -text {Top-to-Bottom} -variable dlgdata($id,position,topbottom)

    pack $page.f1 -anchor center -expand 1 -fill x -side top 
    pack $page.f1.menubar -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f1.pos3  -anchor center -expand 1 -fill x -side right 
    pack $page.f1.pos2  -anchor center -expand 1 -fill x -side right 
    pack $page.f1.pos1  -anchor center -expand 1 -fill x -side right 
    pack $page.f1.pos0  -anchor center -expand 1 -fill x -side right 
    pack $page.f2 -anchor center -expand 1 -fill x -side top 
    pack $page.f2.toolbar -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f2.pos3  -anchor center -expand 1 -fill x -side right 
    pack $page.f2.pos2  -anchor center -expand 1 -fill x -side right 
    pack $page.f2.pos1  -anchor center -expand 1 -fill x -side right 
    pack $page.f2.pos0  -anchor center -expand 1 -fill x -side right 
    pack $page.f3 -anchor center -expand 1 -fill x -side top 
    pack $page.f3.statusbar -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f3.pos2  -anchor center -expand 1 -fill x -side right 
    pack $page.f3.pos0  -anchor center -expand 1 -fill x -side right 
    pack $page.f4 -anchor center -expand 1 -fill x -side top 
    pack $page.f4.orient -anchor center -expand 0 -fill none -padx 5 -side left 
    pack $page.f4.tb  -anchor center -expand 1 -fill x -side right 
    pack $page.f4.lr  -anchor center -expand 1 -fill x -side right 
}

proc dialog-prefs:CreatePredefinedPage {this} {
#--------------------------------------------
    set page [dialog:CreateTabPage $this Predefined]

    frame  $page.f1 -borderwidth 1 -height 1 -relief flat -width 30 
    label $page.f1.label -padx 9 -pady 3 -relief flat -text "Color schemes" -width 10 -anchor w
    listbox $page.f1.list -height 1 -relief sunken  -borderwidth 1 -yscrollcommand "$page.f1.yscroll set"
    scrollbar $page.f1.yscroll -orient vertical -relief ridge -command "$page.f1.list yview"
    bind $page.f1.list <Button-1> {main:DlgDispatch OnSelectScheme "" [%W index @%x,%y] colors}

    frame  $page.f2 -borderwidth 1 -height 1 -relief flat -width 30 
    label $page.f2.label -padx 9 -pady 3 -relief flat -text "Font schemes" -width 10 -anchor w
    listbox $page.f2.list -height 1 -relief sunken  -borderwidth 1 -yscrollcommand "$page.f2.yscroll set"
    scrollbar $page.f2.yscroll -orient vertical -relief ridge -command "$page.f2.list yview"
    bind $page.f2.list <Button-1> {main:DlgDispatch OnSelectScheme "" [%W index @%x,%y] fonts}

    pack $page.f1 -anchor center -expand 1 -fill both -side left
    pack $page.f1.label -expand 0 -fill x -side top
    pack $page.f1.list -expand 1 -fill both -side left
    pack $page.f1.yscroll -fill y -side right

    pack $page.f2 -anchor center -expand 1 -fill both -side left
    pack $page.f2.label -expand 0 -fill x -side top
    pack $page.f2.list -expand 1 -fill both -side left
    pack $page.f2.yscroll -fill y -side right
}

proc dialog-prefs:OnInitDialog {this} {
#----------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]

    set dlgdata($id,fonts_list) { menu tool status caption def }
    set dlgdata($id,colors_list) { \
        workspacebg \
        activefg activebg inactivefg inactivebg \
        tooltipfg tooltipbg \
        textfg textbg textselfg textselbg \
        projectfg projectbg projectselfg projectselbg \
        outputfg outputbg outputselfg outputselbg \
        }
    set dlgdata($id,positions_list) { menubar toolbar statusbar leftright topbottom }

    dialog-prefs:DownloadData $this

    foreach name $dlgdata($id,fonts_list) {
        set dlgdata($id,font,$name) [main:GetMainData font $name]
    }
    set i 0
    foreach name $dlgdata($id,colors_list) {
        set dlgdata($id,def_color,$i)    $dlgdata($id,cur_color,$i)
        incr i
    }
    foreach name $dlgdata($id,positions_list) {
        set dlgdata($id,prevpos,$name)  $dlgdata($id,position,$name)
    }

    set page [dialog:GetTabPage $this Colors]
    $page.f1.list insert end "Workspace bg"
    $page.f1.list insert end "Active Frame fg"
    $page.f1.list insert end "Active Frame bg"
    $page.f1.list insert end "Inactive Frame fg"
    $page.f1.list insert end "Inactive Frame bg"
    $page.f1.list insert end "Tooltip fg"
    $page.f1.list insert end "Tooltip bg"
    $page.f1.list insert end "Text fg"
    $page.f1.list insert end "Text bg"
    $page.f1.list insert end "Text Selection fg"
    $page.f1.list insert end "Text Selection bg"
    $page.f1.list insert end "Project fg"
    $page.f1.list insert end "Project bg"
    $page.f1.list insert end "Project Selection fg"
    $page.f1.list insert end "Project Selection bg"
    $page.f1.list insert end "Output fg"
    $page.f1.list insert end "Output bg"
    $page.f1.list insert end "Output Selection fg"
    $page.f1.list insert end "Output Selection bg"
    $page.f1.list selection set 0
    dialog-prefs:OnSelectColorItem $this 0

    set app_home [main:GetMainData app home]
    set dlgdata($id,predef_fonts)  [lsort [glob -nocomplain $app_home/schemes/font/*.res]]
    set dlgdata($id,predef_colors) [lsort [glob -nocomplain $app_home/schemes/color/*.res]]
    set page [dialog:GetTabPage $this Predefined]
    foreach name $dlgdata($id,predef_colors) {
        if {[file isfile $name]} {
            set f [open $name "r"]
            if {$f != ""} {
                gets $f line
                set line [string trimleft $line "\#"]
                set line [string trimleft $line]
                set line [string trimright $line]
                $page.f1.list insert end $line
                close $f
            } else {
                $page.f2.list insert end "???"
            }
        }
    }
    foreach name $dlgdata($id,predef_fonts) {
        if {[file isfile $name]} {
            set f [open $name "r"]
            if {$f != ""} {
                gets $f line
                set line [string trimleft $line "\#"]
                set line [string trimleft $line]
                set line [string trimright $line]
                $page.f2.list insert end $line
                close $f
            } else {
                $page.f2.list insert end "???"
            }
        }
    }
}

proc dialog-prefs:DownloadData {this} {
#----------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]

    set page [dialog:GetTabPage $this Fonts]
    set i 1
    foreach name $dlgdata($id,fonts_list) {
        $page.f$i.${name}ent   delete 0 end
        $page.f$i.${name}ent   insert end [main:GetMainData font $name]
        incr i
    }
    set i 0
    foreach name $dlgdata($id,colors_list) {
        set dlgdata($id,cur_color,$i)    [main:GetMainData color $name]
        incr i
    }
    foreach name $dlgdata($id,positions_list) {
        set dlgdata($id,position,$name) [main:GetMainData position $name]
    }
}

proc dialog-prefs:OnChooseFont {this which} {
#----------------------------------------
    set name [$which get]
    set dlg [dialog-fontselector:CreateDialog $this $name]
    set result [main:DlgDispatch DoModal $dlg]
    if {$result != ""} {
        $which delete 0 end
        $which insert end $result
    }
}

proc dialog-prefs:OnSelectColorItem {this index} {
#----------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog:GetTabPage $this Colors]

    set rgb $dlgdata($id,cur_color,$index)
    scan [string range $rgb 1 2] "%x" r
    scan [string range $rgb 3 4] "%x" g
    scan [string range $rgb 5 6] "%x" b
    set r [expr ($r + 1)/16]
    set g [expr ($g + 1)/16]
    set b [expr ($b + 1)/16]
    $page.f2.red.s set $r
    $page.f2.green.s set $g
    $page.f2.blue.s set $b
    $page.f2.sample configure -bg $rgb
}

proc dialog-prefs:OnChooseColor {this value} {
#---------------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set page [dialog:GetTabPage $this Colors]

    set r [$page.f2.red.s get]
    if {$r > 0} { set r [expr $r * 16 - 1]}
    set g [$page.f2.green.s get]
    if {$g > 0} { set g [expr $g * 16 - 1]}
    set b [$page.f2.blue.s get]
    if {$b > 0} { set b [expr $b * 16 - 1]}
    set rgb [format "#%02x%02x%02x" $r $g $b]

    $page.f2.sample configure -bg $rgb
    set index [lindex [$page.f1.list curselection] 0]
    set dlgdata($id,cur_color,$index) $rgb
}

proc dialog-prefs:OnSelectScheme {this index type} {
#-----------------------------------------------------
    global main
    global dlgdata
    set id [main:GetWindowId $this]

    set scheme_file [lindex $dlgdata($id,predef_$type) $index]
    uplevel #0 [list source $scheme_file]
    dialog-prefs:DownloadData $this
    main:SetStatusBarText "Sample text"
    main:ChangeAllAppearance
}

proc dialog-prefs:CheckPositions {this postype} {
#---------------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]
    set modified 0
    foreach name $dlgdata($id,positions_list) {
        if {$dlgdata($id,$postype,$name) != [main:GetMainData position $name]} {
            set modified 1
            break;
        }
    }
    if {$modified} {
        foreach name $dlgdata($id,positions_list) {
            main:SetMainData position $name    $dlgdata($id,$postype,$name)
        }
        main:ChangeAllPositions
    }
}

proc dialog-prefs:OnOK {this} {
#------------------------------
    dialog-prefs:OnApply $this
    main:SetStatusBarText ""
    dialog:OnOK $this
}

proc dialog-prefs:OnCancel {this} {
#------------------------------
    global dlgdata
    set id [main:GetWindowId $this]

    dialog-prefs:CheckPositions $this prevpos

    main:SetMainData font menu    $dlgdata($id,font,menu)
    main:SetMainData font tool    $dlgdata($id,font,tool)
    main:SetMainData font status  $dlgdata($id,font,status)
    main:SetMainData font caption $dlgdata($id,font,caption)
    main:SetMainData font def     $dlgdata($id,font,def)
    main:SetStatusBarText ""

    set i 0
    foreach name $dlgdata($id,colors_list) {
        main:SetMainData color $name  $dlgdata($id,def_color,$i)
        incr i
    }

    main:ChangeAllAppearance
    dialog:OnCancel $this
}

proc dialog-prefs:OnApply {this} {
#------------------------------
    global dlgdata
    set id [main:GetWindowId $this]

    dialog-prefs:CheckPositions $this position

    set page [dialog:GetTabPage $this Fonts]
    main:SetMainData font menu    [$page.f1.menuent get]
    main:SetMainData font tool    [$page.f2.toolent get]
    main:SetMainData font status  [$page.f3.statusent get]
    main:SetMainData font caption [$page.f4.captionent get]
    main:SetMainData font def     [$page.f5.defent get]
    main:SetStatusBarText "Sample text"

    set i 0
    foreach name $dlgdata($id,colors_list) {
        main:SetMainData color $name  $dlgdata($id,cur_color,$i)
        incr i
    }
    main:ChangeAllAppearance
}

proc dialog-fontselector:CreateDialog {parent name} {
#-------------------------------------------------
    global dlgdata
    set this [dialog:CreateVertDialog $parent "dialog-fontselector" Cancel Ok]
    if {![winfo exists $this]} {
        return ""
    }
    wm geometry $this 500x400+0+0
    wm minsize $this 400 200
    wm title $this "Select font"

    set id [main:GetWindowId $this]
    set dlgdata($id,name) $name
    set page [dialog:GetDialogFrame $this info]
    frame $page.fonts -borderwidth 1 -height 30 -relief flat -width 30 
    listbox $page.fonts.list -yscrollcommand "$page.fonts.v set"
    scrollbar $page.fonts.v -command "$page.fonts.list yview" -orient vert 
    label $page.sample -height 2 -relief groove -text {Sample text} -width 20 

    pack $page.fonts -anchor center -expand 1 -fill both -side top 
    pack $page.fonts.list -anchor n -expand 1 -fill both -side left 
    pack $page.fonts.v -anchor center -expand 0 -fill y -side right 
    pack $page.sample -anchor center -expand 0 -fill x -side bottom

    bind $page.fonts.list <Button-1> {
        main:DlgDispatch OnSelectFont "" [%W index @%x,%y]
    }
    dialog:CenterDialog $this
    return $this
}

proc dialog-fontselector:OnInitDialog {this} {
#----------------------------------------------
    global dlgdata
    set id [main:GetWindowId $this]

    set page [dialog:GetDialogFrame $this info]
    set res [main:StartExternalProcess $page.fonts.list false false xlsfonts]
    if {$res != ""} {
        main:WaitExternalProcess
    }
    set name $dlgdata($id,name)
    set last [$page.fonts.list index end]
    for {set i 0} {$i < $last} {incr i} {
        set item [$page.fonts.list get $i]
        if {$item == $name} {
            $page.fonts.list selection set $i
            $page.fonts.list see $i
            dialog-fontselector:OnSelectFont $this $i
            break
        }
    }
}

proc dialog-fontselector:OnSelectFont {this index} {
#---------------------------------------------------
    set page [dialog:GetDialogFrame $this info]
    set sel [$page.fonts.list get $index]
    $page.sample configure -font $sel
}

proc dialog-fontselector:OnOK {this} {
#-----------------------------------
    set page [dialog:GetDialogFrame $this info]
    set sel [$page.fonts.list get active]
    dialog:EndDialog $this $sel
}

proc dialog-fontselector:OnCancel {this} {
#-----------------------------------
    dialog:EndDialog $this ""
}
