##############################################################################
#    pvm
#    software development environment
#
#    Copyright (C) 1997  Andrew Guryanov
#    andrew-guryanov@usa.net
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
##############################################################################

#===========================================
#	Global variables and initialization
#===========================================

main:RegisterDocType "doc-text-output"

#===========================================
#	TextOutput document
#===========================================

proc doc-text-output:MatchDocType {filename} {
#---------------------------------------------------
    return 0
}

proc doc-text-output:RenameDocument {this filename} {
#---------------------------------------------------
    global docdata
    doc:RenameDocument $this $filename
    set id [main:GetWindowId $this]
    set docdata($id,title) "Output"
    set docdata($id,path) ""
    set docdata($id,modified) false
}

proc doc-text-output:OnChangeAppearance {this} {
#-----------------------------------------------
    set hull [doc-text:GetHullPath $this]
    $hull.text configure \
        -font [main:GetMainData font def] \
        -fg [main:GetMainData color outputfg] \
        -bg [main:GetMainData color outputbg] \
        -selectforeground [main:GetMainData color outputselfg] \
        -selectbackground [main:GetMainData color outputselbg] \
        -insertbackground [main:GetMainData color outputfg]
}

proc doc-text-output:GetWriteChannel {this clear} {
#---------------------------------------------------
    if {$clear} {
        doc-text:OnEditSelectAll $this
        doc-text:OnEditDelete $this
    }
    return [doc-text:GetHullPath $this].text
}
