namespace app.declares {

    export class CommandInfo{
        name: string;

        constructor(name: string) {
            this.name = name;
        }
    }

    interface IArg {
        argIndex: number;
        argName: string;
        argType: string;
        attribute: string;
        formType: string;
        initialValue;
        input;
    }        

    export interface IOption {
        option: string;
        fullOption: string;
        optionName: string;
        optionProperties: boolean;
        optionNumber: number;
        arg: IArg[];
    }

    export interface IFileInfo {
        fileId: string,
        name: string,
        parentId: string,
        fileType: string,
        createdAt: string,
        updatedAt: string
    }

    export interface IDirectoryInfo extends IFileInfo {
        fileId: string,
        name: string,
        parentId: string,
        fileType: string,
        createdAt: string,
        updatedAt: string,
        path: string
    }

    export interface IResponse extends ng.resource.IResource<IResponse> {
        status: string,
        message: string,
        info: any
    }

    export interface IResponseOption extends IResponse {
        status: string,
        message: string,
        info: IOption[]
    }

    export interface IResponseFileInfo extends IResponse {
        status: string,
        message: string,
        info: IFileInfo[]
    }

    export interface IResponseResource extends ng.resource.IResourceClass<IResponse> {
        //customAction(): any
        execute(): any
    }

}
declare var io : {
    connect(): Socket;
}
interface Socket {
    on(event: string, callback: (data: any) => void );
    emit(event: string, data: any);
}

