namespace app.services {
    export class APIEndPoint {

        private $resource: ng.resource.IResourceService;
        private $http: ng.IHttpService;

        constructor($resource: ng.resource.IResourceService, $http: ng.IHttpService) {
            this.$resource = $resource;
            this.$http = $http;
        }

        private resource(endPoint: string, data: any) {
            /**
             * setting custom action
             */
            var customAction: ng.resource.IActionDescriptor = {
                method: 'GET',
                isArray: false
            };

            var execute: ng.resource.IActionDescriptor = {
                method: 'POST',
                //transformRequest: data,
                headers: {'Content-Type':undefined, enctype:'multipart/form-data'}
            };

            return <declares.IResponseResource> this.$resource(endPoint, {}, { execute: execute});
        }

        public getOptionControlFile(command: string): ng.resource.IResource<declares.IResponse> {
            var endPoint = '/api/v1/optionControlFile/' + command;
            return <declares.IResponseOption>this.resource(endPoint, {}).get();
        }

        public getFiles(fileId: string): ng.resource.IResource<declares.IResponse> {
            var endPoint = '/api/v1/workspace'; 

            if(fileId) {
                endPoint += '/' + fileId;
            }
            return <declares.IResponseFileInfo>this.resource(endPoint,{}).get();
        }

        public getDirectories(): ng.resource.IResource<declares.IResponse> {
            var endPoint = '/api/v1/all/workspace/directory';

            return this.resource(endPoint,{}).get();
        }

        public getTags(): ng.resource.IResource<declares.IResponse> {
            var endPoint = '/api/v1/tagList';
            return this.resource(endPoint, {}).get();
        }

        public getCommands(): ng.resource.IResource<declares.IResponse> {
            var endPoint = '/api/v1/commandList';
            return this.resource(endPoint, {}).get();
        }

        public execute(data: any): ng.IHttpPromise<{}> {
            var endPoint = '/api/v1/execution';
            var fd = new FormData()
            fd.append('data', data);
            return this.$http.post(endPoint,
            fd, 
            {
                headers: {'Content-Type': undefined },
                transformRequest: angular.identity
            });
        }

        public debug(): ng.IHttpPromise<string> {
            var endPoint = '/api/v1/debug';
            return this.$http.get(endPoint);
        }
        public help(command:string): ng.IHttpPromise<string> {
            var endPoint = '/api/v1/help/' + command;
            return this.$http.get(endPoint);
        }

    }
}
