namespace app.services{
    export class Console {
        private directiveIDs: string[];

        constructor(private WebSocket: services.WebSocket,
                    private $rootScope: ng.IRootScopeService
                   ) {
            this.WebSocket = WebSocket;
            this.$rootScope = $rootScope;
            this.directiveIDs = [];

            const directiveIDs = this.directiveIDs;

            this.WebSocket.on('console', (d) => {
                const id = d.id;
                const message = d.message;
                

                if(directiveIDs.indexOf(id) > -1) {
                    $rootScope.$emit(id, message);
                }
            });
        }

        public addDirective(id: string) {
            if(!(this.directiveIDs.indexOf(id) > -1)) {
                this.directiveIDs.push(id); 
            }
        }

        public removeDirective(id: string) {
            const i = this.directiveIDs.indexOf(id);
            if(i > -1) {
                this.directiveIDs.splice(i,1);
            }
        }

        public showIDs() {
            console.log(this.directiveIDs);
        }
    }
}
