'use strict';

var express    = require('express');
var router     = express.Router()
var path       = require('path')
var formidable = require('formidable')
var db = require(__dirname + '/../../../../server/class/DB').instance;
var eos = require(__dirname + '/../../../../server/class/Eos').instance;
var ws = require(__dirname + '/../../../../server/class/WebSocket').instance;

router.post('/', function(req, res) {

    ws.emit();

    var form = new formidable.IncomingForm();
    var root; 
    var result;

    var command;
    var options;
    var workspace;

    var optionsArray;

    if(process.env.NODE_ENV === 'debug') {
        root = __dirname + '/../../../../user-specific-files/workspace.debug/';
    } else {
        root = __dirname + '/../../../../user-specific-files/workspace/';
    }

    form.parse(req, function(err, fields, files) {
        var data = JSON.parse(fields.data);
        command = data.command;
        options = data.options;
        workspace = data.workspace;
    });

    form.on('end', function() {
        Promise.all([eos.validate(command,options, workspace), eos.toExecArray(command, options, workspace)])
        .catch(function(r) {
            var info = {
                status: 'error',
                message: r.message
            };
            console.log(r.message);
            res.send(info);
        })
        .then(function(r) {
            var optionsArray = r[1];
            return eos.execute(command, optionsArray);
        }).then(function(r) {
            var info = {
                status: 'success',
            };
            res.send(r);
        });
    });
});

module.exports = router;
